/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.math.BigInteger;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (RSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger phi;
        BigInteger n2;
        BigInteger q2;
        BigInteger p2;
        int strength = this.param.getStrength();
        int pbitlength = (strength + 1) / 2;
        int qbitlength = strength - pbitlength;
        int mindiffbits = strength / 3;
        BigInteger e2 = this.param.getPublicExponent();
        while ((p2 = new BigInteger(pbitlength, 1, this.param.getRandom())).mod(e2).equals(ONE) || !p2.isProbablePrime(this.param.getCertainty()) || !e2.gcd(p2.subtract(ONE)).equals(ONE)) {
        }
        while (true) {
            if ((q2 = new BigInteger(qbitlength, 1, this.param.getRandom())).subtract(p2).abs().bitLength() < mindiffbits || q2.mod(e2).equals(ONE) || !q2.isProbablePrime(this.param.getCertainty()) || !e2.gcd(q2.subtract(ONE)).equals(ONE)) {
                continue;
            }
            n2 = p2.multiply(q2);
            if (n2.bitLength() == this.param.getStrength()) break;
            p2 = p2.max(q2);
        }
        if (p2.compareTo(q2) < 0) {
            phi = p2;
            p2 = q2;
            q2 = phi;
        }
        BigInteger pSub1 = p2.subtract(ONE);
        BigInteger qSub1 = q2.subtract(ONE);
        phi = pSub1.multiply(qSub1);
        BigInteger d2 = e2.modInverse(phi);
        BigInteger dP = d2.remainder(pSub1);
        BigInteger dQ = d2.remainder(qSub1);
        BigInteger qInv = q2.modInverse(p2);
        return new AsymmetricCipherKeyPair(new RSAKeyParameters(false, n2, e2), new RSAPrivateCrtKeyParameters(n2, e2, d2, p2, q2, dP, dQ, qInv));
    }
}

