/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.CertificationRequest;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import com.timevale.tgtext.bouncycastle.pkcs.PKCSException;
import com.timevale.tgtext.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class PKCS10CertificationRequest {
    private static Attribute[] EMPTY_ARRAY = new Attribute[0];
    private CertificationRequest certificationRequest;

    private static CertificationRequest parseBytes(byte[] encoding) throws IOException {
        try {
            return CertificationRequest.getInstance(ASN1Primitive.fromByteArray(encoding));
        }
        catch (ClassCastException e2) {
            throw new PKCSIOException("malformed data: " + e2.getMessage(), e2);
        }
        catch (IllegalArgumentException e3) {
            throw new PKCSIOException("malformed data: " + e3.getMessage(), e3);
        }
    }

    public PKCS10CertificationRequest(CertificationRequest certificationRequest) {
        this.certificationRequest = certificationRequest;
    }

    public PKCS10CertificationRequest(byte[] encoded) throws IOException {
        this(PKCS10CertificationRequest.parseBytes(encoded));
    }

    public CertificationRequest toASN1Structure() {
        return this.certificationRequest;
    }

    public X500Name getSubject() {
        return X500Name.getInstance(this.certificationRequest.getCertificationRequestInfo().getSubject());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.certificationRequest.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.certificationRequest.getSignature().getBytes();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.certificationRequest.getCertificationRequestInfo().getSubjectPublicKeyInfo();
    }

    public Attribute[] getAttributes() {
        ASN1Set attrSet = this.certificationRequest.getCertificationRequestInfo().getAttributes();
        if (attrSet == null) {
            return EMPTY_ARRAY;
        }
        Attribute[] attrs = new Attribute[attrSet.size()];
        for (int i2 = 0; i2 != attrSet.size(); ++i2) {
            attrs[i2] = Attribute.getInstance(attrSet.getObjectAt(i2));
        }
        return attrs;
    }

    public Attribute[] getAttributes(ASN1ObjectIdentifier type) {
        ASN1Set attrSet = this.certificationRequest.getCertificationRequestInfo().getAttributes();
        if (attrSet == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (int i2 = 0; i2 != attrSet.size(); ++i2) {
            Attribute attr = Attribute.getInstance(attrSet.getObjectAt(i2));
            if (!attr.getAttrType().equals(type)) continue;
            list.add(attr);
        }
        if (list.size() == 0) {
            return EMPTY_ARRAY;
        }
        return list.toArray(new Attribute[list.size()]);
    }

    public byte[] getEncoded() throws IOException {
        return this.certificationRequest.getEncoded();
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws PKCSException {
        ContentVerifier verifier;
        CertificationRequestInfo requestInfo = this.certificationRequest.getCertificationRequestInfo();
        try {
            verifier = verifierProvider.get(this.certificationRequest.getSignatureAlgorithm());
            OutputStream sOut = verifier.getOutputStream();
            sOut.write(requestInfo.getEncoded("DER"));
            sOut.close();
        }
        catch (Exception e2) {
            throw new PKCSException("unable to process signature: " + e2.getMessage(), e2);
        }
        return verifier.verify(this.certificationRequest.getSignature().getBytes());
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof PKCS10CertificationRequest)) {
            return false;
        }
        PKCS10CertificationRequest other = (PKCS10CertificationRequest)o2;
        return this.toASN1Structure().equals(other.toASN1Structure());
    }

    public int hashCode() {
        return this.toASN1Structure().hashCode();
    }
}

