/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CMPCertificate;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PBMParameter;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIBody;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIHeader;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIMessage;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.cmp.CMPException;
import com.timevale.tgtext.bouncycastle.cert.cmp.GeneralPKIMessage;
import com.timevale.tgtext.bouncycastle.cert.crmf.PKMACBuilder;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import com.timevale.tgtext.bouncycastle.operator.MacCalculator;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

public class ProtectedPKIMessage {
    private PKIMessage pkiMessage;

    public ProtectedPKIMessage(GeneralPKIMessage pkiMessage) {
        if (!pkiMessage.hasProtection()) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = pkiMessage.toASN1Structure();
    }

    ProtectedPKIMessage(PKIMessage pkiMessage) {
        if (pkiMessage.getHeader().getProtectionAlg() == null) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = pkiMessage;
    }

    public PKIHeader getHeader() {
        return this.pkiMessage.getHeader();
    }

    public PKIBody getBody() {
        return this.pkiMessage.getBody();
    }

    public PKIMessage toASN1Structure() {
        return this.pkiMessage;
    }

    public boolean hasPasswordBasedMacProtection() {
        return this.pkiMessage.getHeader().getProtectionAlg().getAlgorithm().equals(CMPObjectIdentifiers.passwordBasedMac);
    }

    public X509CertificateHolder[] getCertificates() {
        CMPCertificate[] certs = this.pkiMessage.getExtraCerts();
        if (certs == null) {
            return new X509CertificateHolder[0];
        }
        X509CertificateHolder[] res = new X509CertificateHolder[certs.length];
        for (int i2 = 0; i2 != certs.length; ++i2) {
            res[i2] = new X509CertificateHolder(certs[i2].getX509v3PKCert());
        }
        return res;
    }

    public boolean verify(ContentVerifierProvider verifierProvider) throws CMPException {
        try {
            ContentVerifier verifier = verifierProvider.get(this.pkiMessage.getHeader().getProtectionAlg());
            return this.verifySignature(this.pkiMessage.getProtection().getBytes(), verifier);
        }
        catch (Exception e2) {
            throw new CMPException("unable to verify signature: " + e2.getMessage(), e2);
        }
    }

    public boolean verify(PKMACBuilder pkMacBuilder, char[] password) throws CMPException {
        if (!CMPObjectIdentifiers.passwordBasedMac.equals(this.pkiMessage.getHeader().getProtectionAlg().getAlgorithm())) {
            throw new CMPException("protection algorithm not mac based");
        }
        try {
            pkMacBuilder.setParameters(PBMParameter.getInstance(this.pkiMessage.getHeader().getProtectionAlg().getParameters()));
            MacCalculator calculator = pkMacBuilder.build(password);
            OutputStream macOut = calculator.getOutputStream();
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(this.pkiMessage.getHeader());
            v2.add(this.pkiMessage.getBody());
            macOut.write(new DERSequence(v2).getEncoded("DER"));
            macOut.close();
            return Arrays.areEqual(calculator.getMac(), this.pkiMessage.getProtection().getBytes());
        }
        catch (Exception e2) {
            throw new CMPException("unable to verify MAC: " + e2.getMessage(), e2);
        }
    }

    private boolean verifySignature(byte[] signature, ContentVerifier verifier) throws IOException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.pkiMessage.getHeader());
        v2.add(this.pkiMessage.getBody());
        OutputStream sOut = verifier.getOutputStream();
        sOut.write(new DERSequence(v2).getEncoded("DER"));
        sOut.close();
        return verifier.verify(signature);
    }
}

