/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import com.timevale.tgtext.bouncycastle.jce.interfaces.ElGamalPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

public class ElGamalUtil {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof ElGamalPublicKey) {
            ElGamalPublicKey k2 = (ElGamalPublicKey)key;
            return new ElGamalPublicKeyParameters(k2.getY(), new ElGamalParameters(k2.getParameters().getP(), k2.getParameters().getG()));
        }
        if (key instanceof DHPublicKey) {
            DHPublicKey k3 = (DHPublicKey)key;
            return new ElGamalPublicKeyParameters(k3.getY(), new ElGamalParameters(k3.getParams().getP(), k3.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify public key for El Gamal.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ElGamalPrivateKey) {
            ElGamalPrivateKey k2 = (ElGamalPrivateKey)key;
            return new ElGamalPrivateKeyParameters(k2.getX(), new ElGamalParameters(k2.getParameters().getP(), k2.getParameters().getG()));
        }
        if (key instanceof DHPrivateKey) {
            DHPrivateKey k3 = (DHPrivateKey)key;
            return new ElGamalPrivateKeyParameters(k3.getX(), new ElGamalParameters(k3.getParams().getP(), k3.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify private key for El Gamal.");
    }
}

