/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.StreamCipher;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.tls.SecurityParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsMac;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsStreamCipher(TlsClientContext context, StreamCipher encryptCipher, StreamCipher decryptCipher, Digest writeDigest, Digest readDigest, int cipherKeySize) throws IOException {
        this.context = context;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        int prfSize = 2 * cipherKeySize + writeDigest.getDigestSize() + readDigest.getDigestSize();
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] keyBlock = TlsUtils.PRF(securityParameters.masterSecret, "key expansion", TlsUtils.concat(securityParameters.serverRandom, securityParameters.clientRandom), prfSize);
        this.writeMac = new TlsMac(context, writeDigest, keyBlock, 0, writeDigest.getDigestSize());
        int offset = 0 + writeDigest.getDigestSize();
        this.readMac = new TlsMac(context, readDigest, keyBlock, offset, readDigest.getDigestSize());
        KeyParameter encryptKey = new KeyParameter(keyBlock, offset += readDigest.getDigestSize(), cipherKeySize);
        KeyParameter decryptKey = new KeyParameter(keyBlock, offset += cipherKeySize, cipherKeySize);
        if ((offset += cipherKeySize) != prfSize) {
            throw new TlsFatalAlert(80);
        }
        encryptCipher.init(true, encryptKey);
        decryptCipher.init(true, decryptKey);
    }

    @Override
    public byte[] encodePlaintext(short type, byte[] plaintext, int offset, int len) {
        byte[] mac = this.writeMac.calculateMac(type, plaintext, offset, len);
        byte[] outbuf = new byte[len + mac.length];
        this.encryptCipher.processBytes(plaintext, offset, len, outbuf, 0);
        this.encryptCipher.processBytes(mac, 0, mac.length, outbuf, len);
        return outbuf;
    }

    @Override
    public byte[] decodeCiphertext(short type, byte[] ciphertext, int offset, int len) throws IOException {
        byte[] deciphered = new byte[len];
        this.decryptCipher.processBytes(ciphertext, offset, len, deciphered, 0);
        int plaintextSize = len - this.readMac.getSize();
        byte[] plainText = this.copyData(deciphered, 0, plaintextSize);
        byte[] receivedMac = this.copyData(deciphered, plaintextSize, this.readMac.getSize());
        byte[] computedMac = this.readMac.calculateMac(type, plainText, 0, plainText.length);
        if (!Arrays.constantTimeAreEqual(receivedMac, computedMac)) {
            throw new TlsFatalAlert(20);
        }
        return plainText;
    }

    protected byte[] copyData(byte[] text, int offset, int len) {
        byte[] result = new byte[len];
        System.arraycopy(text, offset, result, 0, len);
        return result;
    }
}

