/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.util.Arrays;

public class GMSSPublicKey
extends ASN1Object {
    private ASN1Integer version;
    private byte[] publicKey;

    private GMSSPublicKey(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("size of seq = " + seq.size());
        }
        this.version = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.publicKey = ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets();
    }

    public GMSSPublicKey(byte[] publicKeyBytes) {
        this.version = new ASN1Integer(0L);
        this.publicKey = publicKeyBytes;
    }

    public static GMSSPublicKey getInstance(Object o2) {
        if (o2 instanceof GMSSPublicKey) {
            return (GMSSPublicKey)o2;
        }
        if (o2 != null) {
            return new GMSSPublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public byte[] getPublicKey() {
        return Arrays.clone(this.publicKey);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.version);
        v2.add(new DEROctetString(this.publicKey));
        return new DERSequence(v2);
    }
}

