/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.rainbow;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.pqc.asn1.RainbowPublicKey;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.spec.RainbowPublicKeySpec;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.security.PublicKey;

public class BCRainbowPublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private short[][] coeffquadratic;
    private short[][] coeffsingular;
    private short[] coeffscalar;
    private int docLength;
    private RainbowParameters rainbowParams;

    public BCRainbowPublicKey(int docLength, short[][] coeffQuadratic, short[][] coeffSingular, short[] coeffScalar) {
        this.docLength = docLength;
        this.coeffquadratic = coeffQuadratic;
        this.coeffsingular = coeffSingular;
        this.coeffscalar = coeffScalar;
    }

    public BCRainbowPublicKey(RainbowPublicKeySpec keySpec) {
        this(keySpec.getDocLength(), keySpec.getCoeffQuadratic(), keySpec.getCoeffSingular(), keySpec.getCoeffScalar());
    }

    public BCRainbowPublicKey(RainbowPublicKeyParameters params) {
        this(params.getDocLength(), params.getCoeffQuadratic(), params.getCoeffSingular(), params.getCoeffScalar());
    }

    public int getDocLength() {
        return this.docLength;
    }

    public short[][] getCoeffQuadratic() {
        return this.coeffquadratic;
    }

    public short[][] getCoeffSingular() {
        short[][] copy = new short[this.coeffsingular.length][];
        for (int i2 = 0; i2 != this.coeffsingular.length; ++i2) {
            copy[i2] = Arrays.clone(this.coeffsingular[i2]);
        }
        return copy;
    }

    public short[] getCoeffScalar() {
        return Arrays.clone(this.coeffscalar);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BCRainbowPublicKey)) {
            return false;
        }
        BCRainbowPublicKey otherKey = (BCRainbowPublicKey)other;
        return this.docLength == otherKey.getDocLength() && RainbowUtil.equals(this.coeffquadratic, otherKey.getCoeffQuadratic()) && RainbowUtil.equals(this.coeffsingular, otherKey.getCoeffSingular()) && RainbowUtil.equals(this.coeffscalar, otherKey.getCoeffScalar());
    }

    public int hashCode() {
        int hash = this.docLength;
        hash = hash * 37 + Arrays.hashCode(this.coeffquadratic);
        hash = hash * 37 + Arrays.hashCode(this.coeffsingular);
        hash = hash * 37 + Arrays.hashCode(this.coeffscalar);
        return hash;
    }

    @Override
    public final String getAlgorithm() {
        return "Rainbow";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        RainbowPublicKey key = new RainbowPublicKey(this.docLength, this.coeffquadratic, this.coeffsingular, this.coeffscalar);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, (ASN1Encodable)DERNull.INSTANCE);
        return KeyUtil.getEncodedSubjectPublicKeyInfo(algorithmIdentifier, key);
    }
}

