/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;

public class NullEngine
implements BlockCipher {
    private boolean initialised;
    protected static final int BLOCK_SIZE = 1;

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.initialised = true;
    }

    @Override
    public String getAlgorithmName() {
        return "Null";
    }

    @Override
    public int getBlockSize() {
        return 1;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Null engine not initialised");
        }
        if (inOff + 1 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 1 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 <= 0; ++i2) {
            out[outOff] = in[inOff];
        }
        return 1;
    }

    @Override
    public void reset() {
    }
}

