/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.x509.Attribute;

public class X509Attribute
extends ASN1Object {
    Attribute attr;

    X509Attribute(ASN1Encodable at2) {
        this.attr = Attribute.getInstance(at2);
    }

    public X509Attribute(String oid, ASN1Encodable value) {
        this.attr = new Attribute(new ASN1ObjectIdentifier(oid), new DERSet(value));
    }

    public X509Attribute(String oid, ASN1EncodableVector value) {
        this.attr = new Attribute(new ASN1ObjectIdentifier(oid), new DERSet(value));
    }

    public String getOID() {
        return this.attr.getAttrType().getId();
    }

    public ASN1Encodable[] getValues() {
        ASN1Set s2 = this.attr.getAttrValues();
        ASN1Encodable[] values = new ASN1Encodable[s2.size()];
        for (int i2 = 0; i2 != s2.size(); ++i2) {
            values[i2] = s2.getObjectAt(i2);
        }
        return values;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.attr.toASN1Primitive();
    }
}

