/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CertifiedKeyPair;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIStatusInfo;

public class CertResponse
extends ASN1Object {
    private ASN1Integer certReqId;
    private PKIStatusInfo status;
    private CertifiedKeyPair certifiedKeyPair;
    private ASN1OctetString rspInfo;

    /*
     * Enabled aggressive block sorting
     */
    private CertResponse(ASN1Sequence seq) {
        this.certReqId = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.status = PKIStatusInfo.getInstance(seq.getObjectAt(1));
        if (seq.size() < 3) return;
        if (seq.size() != 3) {
            this.certifiedKeyPair = CertifiedKeyPair.getInstance(seq.getObjectAt(2));
            this.rspInfo = ASN1OctetString.getInstance(seq.getObjectAt(3));
            return;
        }
        ASN1Encodable o2 = seq.getObjectAt(2);
        if (o2 instanceof ASN1OctetString) {
            this.rspInfo = ASN1OctetString.getInstance(o2);
            return;
        }
        this.certifiedKeyPair = CertifiedKeyPair.getInstance(o2);
    }

    public static CertResponse getInstance(Object o2) {
        if (o2 instanceof CertResponse) {
            return (CertResponse)o2;
        }
        if (o2 != null) {
            return new CertResponse(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CertResponse(ASN1Integer certReqId, PKIStatusInfo status) {
        this(certReqId, status, null, null);
    }

    public CertResponse(ASN1Integer certReqId, PKIStatusInfo status, CertifiedKeyPair certifiedKeyPair, ASN1OctetString rspInfo) {
        if (certReqId == null) {
            throw new IllegalArgumentException("'certReqId' cannot be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("'status' cannot be null");
        }
        this.certReqId = certReqId;
        this.status = status;
        this.certifiedKeyPair = certifiedKeyPair;
        this.rspInfo = rspInfo;
    }

    public ASN1Integer getCertReqId() {
        return this.certReqId;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        return this.certifiedKeyPair;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.certReqId);
        v2.add(this.status);
        if (this.certifiedKeyPair != null) {
            v2.add(this.certifiedKeyPair);
        }
        if (this.rspInfo != null) {
            v2.add(this.rspInfo);
        }
        return new DERSequence(v2);
    }
}

