/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.esf;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;

public class CommitmentTypeQualifier
extends ASN1Object {
    private ASN1ObjectIdentifier commitmentTypeIdentifier;
    private ASN1Encodable qualifier;

    public CommitmentTypeQualifier(ASN1ObjectIdentifier commitmentTypeIdentifier) {
        this(commitmentTypeIdentifier, null);
    }

    public CommitmentTypeQualifier(ASN1ObjectIdentifier commitmentTypeIdentifier, ASN1Encodable qualifier) {
        this.commitmentTypeIdentifier = commitmentTypeIdentifier;
        this.qualifier = qualifier;
    }

    private CommitmentTypeQualifier(ASN1Sequence as2) {
        this.commitmentTypeIdentifier = (ASN1ObjectIdentifier)as2.getObjectAt(0);
        if (as2.size() > 1) {
            this.qualifier = as2.getObjectAt(1);
        }
    }

    public static CommitmentTypeQualifier getInstance(Object as2) {
        if (as2 instanceof CommitmentTypeQualifier) {
            return (CommitmentTypeQualifier)as2;
        }
        if (as2 != null) {
            return new CommitmentTypeQualifier(ASN1Sequence.getInstance(as2));
        }
        return null;
    }

    public ASN1ObjectIdentifier getCommitmentTypeIdentifier() {
        return this.commitmentTypeIdentifier;
    }

    public ASN1Encodable getQualifier() {
        return this.qualifier;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector dev = new ASN1EncodableVector();
        dev.add(this.commitmentTypeIdentifier);
        if (this.qualifier != null) {
            dev.add(this.qualifier);
        }
        return new DERSequence(dev);
    }
}

