/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.selector;

import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.Target;
import com.timevale.tgtext.bouncycastle.asn1.x509.TargetInformation;
import com.timevale.tgtext.bouncycastle.asn1.x509.Targets;
import com.timevale.tgtext.bouncycastle.cert.AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.AttributeCertificateIssuer;
import com.timevale.tgtext.bouncycastle.cert.X509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.util.Selector;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;

public class X509AttributeCertificateHolderSelector
implements Selector {
    private final AttributeCertificateHolder holder;
    private final AttributeCertificateIssuer issuer;
    private final BigInteger serialNumber;
    private final Date attributeCertificateValid;
    private final X509AttributeCertificateHolder attributeCert;
    private final Collection targetNames;
    private final Collection targetGroups;

    X509AttributeCertificateHolderSelector(AttributeCertificateHolder holder, AttributeCertificateIssuer issuer, BigInteger serialNumber, Date attributeCertificateValid, X509AttributeCertificateHolder attributeCert, Collection targetNames, Collection targetGroups) {
        this.holder = holder;
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        this.attributeCertificateValid = attributeCertificateValid;
        this.attributeCert = attributeCert;
        this.targetNames = targetNames;
        this.targetGroups = targetGroups;
    }

    @Override
    public boolean match(Object obj) {
        Extension targetInfoExt;
        if (!(obj instanceof X509AttributeCertificateHolder)) {
            return false;
        }
        X509AttributeCertificateHolder attrCert = (X509AttributeCertificateHolder)obj;
        if (this.attributeCert != null && !this.attributeCert.equals(attrCert)) {
            return false;
        }
        if (this.serialNumber != null && !attrCert.getSerialNumber().equals(this.serialNumber)) {
            return false;
        }
        if (this.holder != null && !attrCert.getHolder().equals(this.holder)) {
            return false;
        }
        if (this.issuer != null && !attrCert.getIssuer().equals(this.issuer)) {
            return false;
        }
        if (this.attributeCertificateValid != null && !attrCert.isValidOn(this.attributeCertificateValid)) {
            return false;
        }
        if (!(this.targetNames.isEmpty() && this.targetGroups.isEmpty() || (targetInfoExt = attrCert.getExtension(Extension.targetInformation)) == null)) {
            int j2;
            Target[] targets;
            Targets t2;
            int i2;
            boolean found;
            TargetInformation targetinfo;
            try {
                targetinfo = TargetInformation.getInstance(targetInfoExt.getParsedValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            Targets[] targetss = targetinfo.getTargetsObjects();
            if (!this.targetNames.isEmpty()) {
                found = false;
                block2: for (i2 = 0; i2 < targetss.length; ++i2) {
                    t2 = targetss[i2];
                    targets = t2.getTargets();
                    for (j2 = 0; j2 < targets.length; ++j2) {
                        if (!this.targetNames.contains(GeneralName.getInstance(targets[j2].getTargetName()))) continue;
                        found = true;
                        continue block2;
                    }
                }
                if (!found) {
                    return false;
                }
            }
            if (!this.targetGroups.isEmpty()) {
                found = false;
                block4: for (i2 = 0; i2 < targetss.length; ++i2) {
                    t2 = targetss[i2];
                    targets = t2.getTargets();
                    for (j2 = 0; j2 < targets.length; ++j2) {
                        if (!this.targetGroups.contains(GeneralName.getInstance(targets[j2].getTargetGroup()))) continue;
                        found = true;
                        continue block4;
                    }
                }
                if (!found) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Object clone() {
        X509AttributeCertificateHolderSelector sel = new X509AttributeCertificateHolderSelector(this.holder, this.issuer, this.serialNumber, this.attributeCertificateValid, this.attributeCert, this.targetNames, this.targetGroups);
        return sel;
    }

    public X509AttributeCertificateHolder getAttributeCert() {
        return this.attributeCert;
    }

    public Date getAttributeCertificateValid() {
        if (this.attributeCertificateValid != null) {
            return new Date(this.attributeCertificateValid.getTime());
        }
        return null;
    }

    public AttributeCertificateHolder getHolder() {
        return this.holder;
    }

    public AttributeCertificateIssuer getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Collection getTargetNames() {
        return this.targetNames;
    }

    public Collection getTargetGroups() {
        return this.targetGroups;
    }
}

