/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import com.timevale.tgtext.bouncycastle.cms.Recipient;
import com.timevale.tgtext.bouncycastle.cms.RecipientId;
import com.timevale.tgtext.bouncycastle.cms.RecipientOperator;
import com.timevale.tgtext.bouncycastle.cms.a;
import com.timevale.tgtext.bouncycastle.cms.d;
import com.timevale.tgtext.bouncycastle.cms.g;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceAlgorithmIdentifierConverter;
import com.timevale.tgtext.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;

public abstract class RecipientInformation {
    protected RecipientId rid;
    protected AlgorithmIdentifier keyEncAlg;
    protected AlgorithmIdentifier messageAlgorithm;
    protected g secureReadable;
    private a additionalData;
    private byte[] resultMac;
    private RecipientOperator operator;

    RecipientInformation(AlgorithmIdentifier keyEncAlg, AlgorithmIdentifier messageAlgorithm, g secureReadable, a additionalData) {
        this.keyEncAlg = keyEncAlg;
        this.messageAlgorithm = messageAlgorithm;
        this.secureReadable = secureReadable;
        this.additionalData = additionalData;
    }

    public RecipientId getRID() {
        return this.rid;
    }

    private byte[] encodeObj(ASN1Encodable obj) throws IOException {
        if (obj != null) {
            return obj.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncAlg;
    }

    public String getKeyEncryptionAlgOID() {
        return this.keyEncAlg.getObjectId().getId();
    }

    public byte[] getKeyEncryptionAlgParams() {
        try {
            return this.encodeObj(this.keyEncAlg.getParameters());
        }
        catch (Exception e2) {
            throw new RuntimeException("exception getting encryption parameters " + e2);
        }
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return new JceAlgorithmIdentifierConverter().setProvider(provider).getAlgorithmParameters(this.keyEncAlg);
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(Provider provider) throws CMSException {
        return new JceAlgorithmIdentifierConverter().setProvider(provider).getAlgorithmParameters(this.keyEncAlg);
    }

    public byte[] getContent(Key key, String provider) throws CMSException, NoSuchProviderException {
        return this.getContent(key, i.a(provider));
    }

    public byte[] getContent(Key key, Provider provider) throws CMSException {
        try {
            return i.b(this.getContentStream(key, provider).getContentStream());
        }
        catch (IOException e2) {
            throw new RuntimeException("unable to parse internal stream: " + e2);
        }
    }

    public byte[] getContentDigest() {
        if (this.secureReadable instanceof d.b) {
            return ((d.b)this.secureReadable).b();
        }
        return null;
    }

    public byte[] getMac() {
        if (this.resultMac == null && this.operator.isMacBased()) {
            if (this.additionalData != null) {
                try {
                    Streams.drain(this.operator.getInputStream(new ByteArrayInputStream(this.additionalData.a().getEncoded("DER"))));
                }
                catch (IOException e2) {
                    throw new IllegalStateException("unable to drain input: " + e2.getMessage());
                }
            }
            this.resultMac = this.operator.getMac();
        }
        return this.resultMac;
    }

    public byte[] getContent(Recipient recipient) throws CMSException {
        try {
            return i.b(this.getContentStream(recipient).getContentStream());
        }
        catch (IOException e2) {
            throw new CMSException("unable to parse internal stream: " + e2.getMessage(), e2);
        }
    }

    public CMSTypedStream getContentStream(Key key, String provider) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, i.a(provider));
    }

    public abstract CMSTypedStream getContentStream(Key var1, Provider var2) throws CMSException;

    public CMSTypedStream getContentStream(Recipient recipient) throws CMSException, IOException {
        this.operator = this.getRecipientOperator(recipient);
        if (this.additionalData != null) {
            return new CMSTypedStream(this.secureReadable.a());
        }
        return new CMSTypedStream(this.operator.getInputStream(this.secureReadable.a()));
    }

    protected abstract RecipientOperator getRecipientOperator(Recipient var1) throws CMSException, IOException;
}

