/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.macs;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Mac;
import com.timevale.tgtext.bouncycastle.crypto.macs.a;
import com.timevale.tgtext.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CFBBlockCipherMac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private a cipher;
    private BlockCipherPadding padding = null;
    private int macSize;

    public CFBBlockCipherMac(BlockCipher cipher) {
        this(cipher, 8, (cipher.getBlockSize() << 3) / 2, null);
    }

    public CFBBlockCipherMac(BlockCipher cipher, BlockCipherPadding padding) {
        this(cipher, 8, (cipher.getBlockSize() << 3) / 2, padding);
    }

    public CFBBlockCipherMac(BlockCipher cipher, int cfbBitSize, int macSizeInBits) {
        this(cipher, cfbBitSize, macSizeInBits, null);
    }

    public CFBBlockCipherMac(BlockCipher cipher, int cfbBitSize, int macSizeInBits, BlockCipherPadding padding) {
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.mac = new byte[cipher.getBlockSize()];
        this.cipher = new a(cipher, cfbBitSize);
        this.padding = padding;
        this.macSize = macSizeInBits / 8;
        this.buf = new byte[this.cipher.b()];
        this.bufOff = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.a();
    }

    @Override
    public void init(CipherParameters params) {
        this.reset();
        this.cipher.a(params);
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte in) {
        if (this.bufOff == this.buf.length) {
            this.cipher.a(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int blockSize = this.cipher.b();
        int gapLen = blockSize - this.bufOff;
        if (len > gapLen) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, gapLen);
            this.cipher.a(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            len -= gapLen;
            inOff += gapLen;
            while (len > blockSize) {
                this.cipher.a(in, inOff, this.mac, 0);
                len -= blockSize;
                inOff += blockSize;
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int blockSize = this.cipher.b();
        if (this.padding == null) {
            while (this.bufOff < blockSize) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            this.padding.addPadding(this.buf, this.bufOff);
        }
        this.cipher.a(this.buf, 0, this.mac, 0);
        this.cipher.a(this.mac);
        System.arraycopy(this.mac, 0, out, outOff, this.macSize);
        this.reset();
        return this.macSize;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.cipher.c();
    }
}

