/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.params;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.DenseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Polynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.ProductFormPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.SparseTernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class NTRUSigningPrivateKeyParameters
extends AsymmetricKeyParameter {
    private List<Basis> bases;
    private NTRUSigningPublicKeyParameters publicKey;

    public NTRUSigningPrivateKeyParameters(byte[] b2, NTRUSigningKeyGenerationParameters params) throws IOException {
        this(new ByteArrayInputStream(b2), params);
    }

    public NTRUSigningPrivateKeyParameters(InputStream is, NTRUSigningKeyGenerationParameters params) throws IOException {
        super(true);
        this.bases = new ArrayList<Basis>();
        for (int i2 = 0; i2 <= params.B; ++i2) {
            this.add(new Basis(is, params, i2 != 0));
        }
        this.publicKey = new NTRUSigningPublicKeyParameters(is, params.getSigningParameters());
    }

    public NTRUSigningPrivateKeyParameters(List<Basis> bases, NTRUSigningPublicKeyParameters publicKey) {
        super(true);
        this.bases = new ArrayList<Basis>(bases);
        this.publicKey = publicKey;
    }

    private void add(Basis b2) {
        this.bases.add(b2);
    }

    public Basis getBasis(int i2) {
        return this.bases.get(i2);
    }

    public NTRUSigningPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < this.bases.size(); ++i2) {
            this.bases.get(i2).encode(os, i2 != 0);
        }
        os.write(this.publicKey.getEncoded());
        return os.toByteArray();
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int result = 31 + (this.bases == null ? 0 : this.bases.hashCode());
        for (Basis basis : this.bases) {
            result += basis.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NTRUSigningPrivateKeyParameters other = (NTRUSigningPrivateKeyParameters)obj;
        if (this.bases == null && other.bases != null) {
            return false;
        }
        if (this.bases.size() != other.bases.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.bases.size(); ++i2) {
            Basis basis1 = this.bases.get(i2);
            Basis basis2 = other.bases.get(i2);
            if (!basis1.f.equals(basis2.f)) {
                return false;
            }
            if (!basis1.fPrime.equals(basis2.fPrime)) {
                return false;
            }
            if (i2 != 0 && !basis1.h.equals(basis2.h)) {
                return false;
            }
            if (basis1.params.equals(basis2.params)) continue;
            return false;
        }
        return true;
    }

    public static class Basis {
        public Polynomial f;
        public Polynomial fPrime;
        public IntegerPolynomial h;
        NTRUSigningKeyGenerationParameters params;

        protected Basis(Polynomial f2, Polynomial fPrime, IntegerPolynomial h2, NTRUSigningKeyGenerationParameters params) {
            this.f = f2;
            this.fPrime = fPrime;
            this.h = h2;
            this.params = params;
        }

        Basis(InputStream is, NTRUSigningKeyGenerationParameters params, boolean include_h) throws IOException {
            Polynomial polynomial;
            Basis basis;
            int N = params.N;
            int q2 = params.q;
            int d1 = params.d1;
            int d2 = params.d2;
            int d3 = params.d3;
            boolean sparse = params.sparse;
            this.params = params;
            if (params.polyType == 1) {
                basis = this;
                polynomial = ProductFormPolynomial.fromBinary(is, N, d1, d2, d3 + 1, d3);
            } else {
                IntegerPolynomial fInt = IntegerPolynomial.fromBinary3Tight(is, N);
                basis = this;
                polynomial = basis.f = sparse ? new SparseTernaryPolynomial(fInt) : new DenseTernaryPolynomial(fInt);
            }
            if (params.basisType == 0) {
                IntegerPolynomial fPrimeInt = IntegerPolynomial.fromBinary(is, N, q2);
                int i2 = 0;
                while (i2 < fPrimeInt.coeffs.length) {
                    int n2 = i2++;
                    fPrimeInt.coeffs[n2] = fPrimeInt.coeffs[n2] - q2 / 2;
                }
                this.fPrime = fPrimeInt;
            } else {
                this.fPrime = params.polyType == 1 ? ProductFormPolynomial.fromBinary(is, N, d1, d2, d3 + 1, d3) : IntegerPolynomial.fromBinary3Tight(is, N);
            }
            if (include_h) {
                this.h = IntegerPolynomial.fromBinary(is, N, q2);
            }
        }

        void encode(OutputStream os, boolean include_h) throws IOException {
            int q2 = this.params.q;
            os.write(this.getEncoded(this.f));
            if (this.params.basisType == 0) {
                IntegerPolynomial fPrimeInt = this.fPrime.toIntegerPolynomial();
                int i2 = 0;
                while (i2 < fPrimeInt.coeffs.length) {
                    int n2 = i2++;
                    fPrimeInt.coeffs[n2] = fPrimeInt.coeffs[n2] + q2 / 2;
                }
                os.write(fPrimeInt.toBinary(q2));
            } else {
                os.write(this.getEncoded(this.fPrime));
            }
            if (include_h) {
                os.write(this.h.toBinary(q2));
            }
        }

        private byte[] getEncoded(Polynomial p2) {
            if (p2 instanceof ProductFormPolynomial) {
                return ((ProductFormPolynomial)p2).toBinary();
            }
            return p2.toIntegerPolynomial().toBinary3Tight();
        }

        public int hashCode() {
            int result = 31 + (this.f == null ? 0 : this.f.hashCode());
            result = result * 31 + (this.fPrime == null ? 0 : this.fPrime.hashCode());
            result = result * 31 + (this.h == null ? 0 : this.h.hashCode());
            result = result * 31 + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Basis)) {
                return false;
            }
            Basis other = (Basis)obj;
            if (this.f == null ? other.f != null : !this.f.equals(other.f)) {
                return false;
            }
            if (this.fPrime == null ? other.fPrime != null : !this.fPrime.equals(other.fPrime)) {
                return false;
            }
            if (this.h == null ? other.h != null : !this.h.equals(other.h)) {
                return false;
            }
            return !(this.params == null ? other.params != null : !this.params.equals(other.params));
        }
    }
}

