/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.signers;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.math.ec.ECAlgorithms;
import com.timevale.tgtext.bouncycastle.math.ec.ECConstants;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECGOST3410Signer
implements DSA {
    ECKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
                return;
            }
            this.random = new SecureRandom();
            this.key = (ECPrivateKeyParameters)param;
            return;
        }
        this.key = (ECPublicKeyParameters)param;
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s2;
        BigInteger r2;
        byte[] mRev = new byte[message.length];
        for (int i2 = 0; i2 != mRev.length; ++i2) {
            mRev[i2] = message[mRev.length - 1 - i2];
        }
        BigInteger e2 = new BigInteger(1, mRev);
        BigInteger n2 = this.key.getParameters().getN();
        while (true) {
            ECPoint p2;
            BigInteger x2;
            BigInteger k2;
            if ((k2 = new BigInteger(n2.bitLength(), this.random)).equals(ECConstants.ZERO) || (r2 = (x2 = (p2 = this.key.getParameters().getG().multiply(k2)).getX().toBigInteger()).mod(n2)).equals(ECConstants.ZERO)) {
                continue;
            }
            BigInteger d2 = ((ECPrivateKeyParameters)this.key).getD();
            s2 = k2.multiply(e2).add(d2.multiply(r2)).mod(n2);
            if (!s2.equals(ECConstants.ZERO)) break;
        }
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] res = bigIntegerArray;
        bigIntegerArray[0] = r2;
        res[1] = s2;
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        byte[] mRev = new byte[message.length];
        for (int i2 = 0; i2 != mRev.length; ++i2) {
            mRev[i2] = message[mRev.length - 1 - i2];
        }
        BigInteger e2 = new BigInteger(1, mRev);
        BigInteger n2 = this.key.getParameters().getN();
        if (r2.compareTo(ECConstants.ONE) < 0 || r2.compareTo(n2) >= 0) {
            return false;
        }
        if (s2.compareTo(ECConstants.ONE) < 0 || s2.compareTo(n2) >= 0) {
            return false;
        }
        BigInteger v2 = e2.modInverse(n2);
        BigInteger z1 = s2.multiply(v2).mod(n2);
        BigInteger z2 = n2.subtract(r2).multiply(v2).mod(n2);
        ECPoint G = this.key.getParameters().getG();
        ECPoint Q = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, z1, Q, z2);
        BigInteger R = point.getX().toBigInteger().mod(n2);
        return R.equals(r2);
    }
}

