/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ec;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.sec.SECNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x9.X962NamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ECParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ECDomainParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ec.EC5Util;
import com.timevale.tgtext.bouncycastle.jce.interfaces.ECPrivateKey;
import com.timevale.tgtext.bouncycastle.jce.interfaces.ECPublicKey;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.jce.spec.ECParameterSpec;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class ECUtil {
    static int[] convertMidTerms(int[] k2) {
        int[] res = new int[3];
        if (k2.length == 1) {
            res[0] = k2[0];
        } else {
            if (k2.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (k2[0] < k2[1] && k2[0] < k2[2]) {
                res[0] = k2[0];
                if (k2[1] < k2[2]) {
                    res[1] = k2[1];
                    res[2] = k2[2];
                } else {
                    res[1] = k2[2];
                    res[2] = k2[1];
                }
            } else if (k2[1] < k2[2]) {
                res[0] = k2[1];
                if (k2[0] < k2[2]) {
                    res[1] = k2[0];
                    res[2] = k2[2];
                } else {
                    res[1] = k2[2];
                    res[2] = k2[0];
                }
            } else {
                res[0] = k2[2];
                if (k2[0] < k2[1]) {
                    res[1] = k2[0];
                    res[2] = k2[1];
                } else {
                    res[1] = k2[1];
                    res[2] = k2[0];
                }
            }
        }
        return res;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            ECPublicKey k2 = (ECPublicKey)key;
            ECParameterSpec s2 = k2.getParameters();
            if (s2 == null) {
                s2 = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
                return new ECPublicKeyParameters(((BCECPublicKey)k2).engineGetQ(), new ECDomainParameters(s2.getCurve(), s2.getG(), s2.getN(), s2.getH(), s2.getSeed()));
            }
            return new ECPublicKeyParameters(k2.getQ(), new ECDomainParameters(s2.getCurve(), s2.getG(), s2.getN(), s2.getH(), s2.getSeed()));
        }
        if (key instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey pubKey = (java.security.interfaces.ECPublicKey)key;
            ECParameterSpec s3 = EC5Util.convertSpec(pubKey.getParams(), false);
            return new ECPublicKeyParameters(EC5Util.convertPoint(pubKey.getParams(), pubKey.getW(), false), new ECDomainParameters(s3.getCurve(), s3.getG(), s3.getN(), s3.getH(), s3.getSeed()));
        }
        try {
            byte[] bytes = key.getEncoded();
            if (bytes == null) {
                throw new InvalidKeyException("no encoding for EC public key");
            }
            PublicKey publicKey = BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(bytes));
            if (publicKey instanceof java.security.interfaces.ECPublicKey) {
                return ECUtil.generatePublicKeyParameter(publicKey);
            }
        }
        catch (Exception e2) {
            throw new InvalidKeyException("cannot identify EC public key: " + e2.toString());
        }
        throw new InvalidKeyException("cannot identify EC public key.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            ECPrivateKey k2 = (ECPrivateKey)key;
            ECParameterSpec s2 = k2.getParameters();
            if (s2 == null) {
                s2 = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            }
            return new ECPrivateKeyParameters(k2.getD(), new ECDomainParameters(s2.getCurve(), s2.getG(), s2.getN(), s2.getH(), s2.getSeed()));
        }
        if (key instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey privKey = (java.security.interfaces.ECPrivateKey)key;
            ECParameterSpec s3 = EC5Util.convertSpec(privKey.getParams(), false);
            return new ECPrivateKeyParameters(privKey.getS(), new ECDomainParameters(s3.getCurve(), s3.getG(), s3.getN(), s3.getH(), s3.getSeed()));
        }
        try {
            byte[] bytes = key.getEncoded();
            if (bytes == null) {
                throw new InvalidKeyException("no encoding for EC private key");
            }
            PrivateKey privateKey = BouncyCastleProvider.getPrivateKey(PrivateKeyInfo.getInstance(bytes));
            if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
                return ECUtil.generatePrivateKeyParameter(privateKey);
            }
        }
        catch (Exception e2) {
            throw new InvalidKeyException("cannot identify EC private key: " + e2.toString());
        }
        throw new InvalidKeyException("can't identify EC private key.");
    }

    public static ASN1ObjectIdentifier getNamedCurveOid(String name) {
        ASN1ObjectIdentifier oid = X962NamedCurves.getOID(name);
        if (oid == null) {
            oid = SECNamedCurves.getOID(name);
            if (oid == null) {
                oid = NISTNamedCurves.getOID(name);
            }
            if (oid == null) {
                oid = TeleTrusTNamedCurves.getOID(name);
            }
            if (oid == null) {
                oid = ECGOST3410NamedCurves.getOID(name);
            }
        }
        return oid;
    }

    public static X9ECParameters getNamedCurveByOid(ASN1ObjectIdentifier oid) {
        X9ECParameters params = X962NamedCurves.getByOID(oid);
        if (params == null) {
            params = SECNamedCurves.getByOID(oid);
            if (params == null) {
                params = NISTNamedCurves.getByOID(oid);
            }
            if (params == null) {
                params = TeleTrusTNamedCurves.getByOID(oid);
            }
        }
        return params;
    }

    public static String getCurveName(ASN1ObjectIdentifier oid) {
        String name = X962NamedCurves.getName(oid);
        if (name == null) {
            name = SECNamedCurves.getName(oid);
            if (name == null) {
                name = NISTNamedCurves.getName(oid);
            }
            if (name == null) {
                name = TeleTrusTNamedCurves.getName(oid);
            }
            if (name == null) {
                name = ECGOST3410NamedCurves.getName(oid);
            }
        }
        return name;
    }
}

