/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ec;

import com.timevale.tgtext.bouncycastle.math.ec.ECConstants;
import com.timevale.tgtext.bouncycastle.math.ec.c;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract String getFieldName();

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public String toString() {
        return this.toBigInteger().toString(2);
    }

    public static class F2m
    extends ECFieldElement {
        public static final int GNB = 1;
        public static final int TPB = 2;
        public static final int PPB = 3;
        private int representation;
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private c x;
        private int t;

        public F2m(int m2, int k1, int k2, int k3, BigInteger x2) {
            this.t = m2 + 31 >> 5;
            this.x = new c(x2, this.t);
            if (k2 == 0 && k3 == 0) {
                this.representation = 2;
            } else {
                if (k2 >= k3) {
                    throw new IllegalArgumentException("k2 must be smaller than k3");
                }
                if (k2 <= 0) {
                    throw new IllegalArgumentException("k2 must be larger than 0");
                }
                this.representation = 3;
            }
            if (x2.signum() < 0) {
                throw new IllegalArgumentException("x value cannot be negative");
            }
            this.m = m2;
            this.k1 = k1;
            this.k2 = k2;
            this.k3 = k3;
        }

        public F2m(int m2, int k2, BigInteger x2) {
            this(m2, k2, 0, 0, x2);
        }

        private F2m(int m2, int k1, int k2, int k3, c x2) {
            this.t = m2 + 31 >> 5;
            this.x = x2;
            this.m = m2;
            this.k1 = k1;
            this.k2 = k2;
            this.k3 = k3;
            if (k2 == 0 && k3 == 0) {
                this.representation = 2;
                return;
            }
            this.representation = 3;
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x.d();
        }

        @Override
        public String getFieldName() {
            return "F2m";
        }

        @Override
        public int getFieldSize() {
            return this.m;
        }

        public static void checkFieldElements(ECFieldElement a2, ECFieldElement b2) {
            if (!(a2 instanceof F2m) || !(b2 instanceof F2m)) {
                throw new IllegalArgumentException("Field elements are not both instances of ECFieldElement.F2m");
            }
            F2m aF2m = (F2m)a2;
            F2m bF2m = (F2m)b2;
            if (aF2m.m != bF2m.m || aF2m.k1 != bF2m.k1 || aF2m.k2 != bF2m.k2 || aF2m.k3 != bF2m.k3) {
                throw new IllegalArgumentException("Field elements are not elements of the same field F2m");
            }
            if (aF2m.representation != bF2m.representation) {
                throw new IllegalArgumentException("One of the field elements are not elements has incorrect representation");
            }
        }

        @Override
        public ECFieldElement add(ECFieldElement b2) {
            c iarrClone = (c)this.x.clone();
            F2m bF2m = (F2m)b2;
            iarrClone.a(bF2m.x, 0);
            return new F2m(this.m, this.k1, this.k2, this.k3, iarrClone);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement b2) {
            return this.add(b2);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement b2) {
            F2m bF2m = (F2m)b2;
            c mult = this.x.b(bF2m.x, this.m);
            mult.a(this.m, new int[]{this.k1, this.k2, this.k3});
            return new F2m(this.m, this.k1, this.k2, this.k3, mult);
        }

        @Override
        public ECFieldElement divide(ECFieldElement b2) {
            ECFieldElement bInv = b2.invert();
            return this.multiply(bInv);
        }

        @Override
        public ECFieldElement negate() {
            return this;
        }

        @Override
        public ECFieldElement square() {
            c squared = this.x.e(this.m);
            squared.a(this.m, new int[]{this.k1, this.k2, this.k3});
            return new F2m(this.m, this.k1, this.k2, this.k3, squared);
        }

        @Override
        public ECFieldElement invert() {
            c uz = (c)this.x.clone();
            c vz = new c(this.t);
            vz.d(this.m);
            vz.d(0);
            vz.d(this.k1);
            if (this.representation == 3) {
                vz.d(this.k2);
                vz.d(this.k3);
            }
            c g1z = new c(this.t);
            g1z.d(0);
            c g2z = new c(this.t);
            while (!uz.a()) {
                int j2 = uz.c() - vz.c();
                if (j2 < 0) {
                    c uzCopy = uz;
                    uz = vz;
                    vz = uzCopy;
                    c g1zCopy = g1z;
                    g1z = g2z;
                    g2z = g1zCopy;
                    j2 = -j2;
                }
                int jInt = j2 >> 5;
                int jBit = j2 & 0x1F;
                c vzShift = vz.a(jBit);
                uz.a(vzShift, jInt);
                c g2zShift = g2z.a(jBit);
                g1z.a(g2zShift, jInt);
            }
            return new F2m(this.m, this.k1, this.k2, this.k3, g2z);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException("Not implemented");
        }

        public int getRepresentation() {
            return this.representation;
        }

        public int getM() {
            return this.m;
        }

        public int getK1() {
            return this.k1;
        }

        public int getK2() {
            return this.k2;
        }

        public int getK3() {
            return this.k3;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof F2m)) {
                return false;
            }
            F2m b2 = (F2m)anObject;
            return this.m == b2.m && this.k1 == b2.k1 && this.k2 == b2.k2 && this.k3 == b2.k3 && this.representation == b2.representation && this.x.equals(b2.x);
        }

        public int hashCode() {
            return this.x.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }
    }

    public static class Fp
    extends ECFieldElement {
        BigInteger x;
        BigInteger q;

        public Fp(BigInteger q2, BigInteger x2) {
            this.x = x2;
            if (x2.compareTo(q2) >= 0) {
                throw new IllegalArgumentException("x value too large in field element");
            }
            this.q = q2;
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x;
        }

        @Override
        public String getFieldName() {
            return "Fp";
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public ECFieldElement add(ECFieldElement b2) {
            return new Fp(this.q, this.x.add(b2.toBigInteger()).mod(this.q));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement b2) {
            return new Fp(this.q, this.x.subtract(b2.toBigInteger()).mod(this.q));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement b2) {
            return new Fp(this.q, this.x.multiply(b2.toBigInteger()).mod(this.q));
        }

        @Override
        public ECFieldElement divide(ECFieldElement b2) {
            return new Fp(this.q, this.x.multiply(b2.toBigInteger().modInverse(this.q)).mod(this.q));
        }

        @Override
        public ECFieldElement negate() {
            return new Fp(this.q, this.x.negate().mod(this.q));
        }

        @Override
        public ECFieldElement square() {
            return new Fp(this.q, this.x.multiply(this.x).mod(this.q));
        }

        @Override
        public ECFieldElement invert() {
            return new Fp(this.q, this.x.modInverse(this.q));
        }

        @Override
        public ECFieldElement sqrt() {
            if (!this.q.testBit(0)) {
                throw new RuntimeException("not done yet");
            }
            if (this.q.testBit(1)) {
                Fp z2 = new Fp(this.q, this.x.modPow(this.q.shiftRight(2).add(ECConstants.ONE), this.q));
                if (((ECFieldElement)z2).square().equals(this)) {
                    return z2;
                }
                return null;
            }
            BigInteger qMinusOne = this.q.subtract(ECConstants.ONE);
            BigInteger legendreExponent = qMinusOne.shiftRight(1);
            if (!this.x.modPow(legendreExponent, this.q).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger u2 = qMinusOne.shiftRight(2);
            BigInteger k2 = u2.shiftLeft(1).add(ECConstants.ONE);
            BigInteger Q = this.x;
            BigInteger fourQ = Q.shiftLeft(2).mod(this.q);
            Random rand = new Random();
            while (true) {
                BigInteger P;
                if ((P = new BigInteger(this.q.bitLength(), rand)).compareTo(this.q) >= 0 || !P.multiply(P).subtract(fourQ).modPow(legendreExponent, this.q).equals(qMinusOne)) {
                    continue;
                }
                BigInteger[] result = Fp.lucasSequence(this.q, P, Q, k2);
                BigInteger U = result[0];
                BigInteger V = result[1];
                if (V.multiply(V).mod(this.q).equals(fourQ)) {
                    if (V.testBit(0)) {
                        V = V.add(this.q);
                    }
                    V = V.shiftRight(1);
                    return new Fp(this.q, V);
                }
                if (!U.equals(ECConstants.ONE) && !U.equals(qMinusOne)) break;
            }
            return null;
        }

        private static BigInteger[] lucasSequence(BigInteger p2, BigInteger P, BigInteger Q, BigInteger k2) {
            int j2;
            int n2 = k2.bitLength();
            int s2 = k2.getLowestSetBit();
            BigInteger Uh = ECConstants.ONE;
            BigInteger Vl = ECConstants.TWO;
            BigInteger Vh = P;
            BigInteger Ql = ECConstants.ONE;
            BigInteger Qh = ECConstants.ONE;
            for (j2 = n2 - 1; j2 >= s2 + 1; --j2) {
                Ql = Ql.multiply(Qh).mod(p2);
                if (k2.testBit(j2)) {
                    Qh = Ql.multiply(Q).mod(p2);
                    Uh = Uh.multiply(Vh).mod(p2);
                    Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p2);
                    Vh = Vh.multiply(Vh).subtract(Qh.shiftLeft(1)).mod(p2);
                    continue;
                }
                Qh = Ql;
                Uh = Uh.multiply(Vl).subtract(Ql).mod(p2);
                Vh = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p2);
                Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p2);
            }
            Ql = Ql.multiply(Qh).mod(p2);
            Qh = Ql.multiply(Q).mod(p2);
            Uh = Uh.multiply(Vl).subtract(Ql).mod(p2);
            Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p2);
            Ql = Ql.multiply(Qh).mod(p2);
            for (j2 = 1; j2 <= s2; ++j2) {
                Uh = Uh.multiply(Vl).mod(p2);
                Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p2);
                Ql = Ql.multiply(Ql).mod(p2);
            }
            return new BigInteger[]{Uh, Vl};
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Fp)) {
                return false;
            }
            Fp o2 = (Fp)other;
            return this.q.equals(o2.q) && this.x.equals(o2.x);
        }

        public int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }
}

