/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.timevale.tgtext.bouncycastle.openssl.MiscPEMGenerator;
import com.timevale.tgtext.bouncycastle.openssl.PEMEncryptor;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.timevale.tgtext.bouncycastle.x509.X509AttributeCertificate;
import com.timevale.tgtext.bouncycastle.x509.X509V2AttributeCertificate;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class JcaMiscPEMGenerator
extends MiscPEMGenerator {
    private Object obj;
    private String algorithm;
    private char[] password;
    private SecureRandom random;
    private Provider provider;

    public JcaMiscPEMGenerator(Object o2) throws IOException {
        super(JcaMiscPEMGenerator.convertObject(o2));
    }

    public JcaMiscPEMGenerator(Object o2, PEMEncryptor encryptor) throws IOException {
        super(JcaMiscPEMGenerator.convertObject(o2), encryptor);
    }

    private static Object convertObject(Object o2) throws IOException {
        if (o2 instanceof X509Certificate) {
            try {
                return new JcaX509CertificateHolder((X509Certificate)o2);
            }
            catch (CertificateEncodingException e2) {
                throw new IllegalArgumentException("Cannot encode object: " + e2.toString());
            }
        }
        if (o2 instanceof X509CRL) {
            try {
                return new JcaX509CRLHolder((X509CRL)o2);
            }
            catch (CRLException e3) {
                throw new IllegalArgumentException("Cannot encode object: " + e3.toString());
            }
        }
        if (o2 instanceof KeyPair) {
            return JcaMiscPEMGenerator.convertObject(((KeyPair)o2).getPrivate());
        }
        if (o2 instanceof PrivateKey) {
            return PrivateKeyInfo.getInstance(((Key)o2).getEncoded());
        }
        if (o2 instanceof PublicKey) {
            return SubjectPublicKeyInfo.getInstance(((PublicKey)o2).getEncoded());
        }
        if (o2 instanceof X509AttributeCertificate) {
            return new JcaX509AttributeCertificateHolder((X509V2AttributeCertificate)o2);
        }
        if (o2 instanceof com.timevale.tgtext.bouncycastle.jce.PKCS10CertificationRequest) {
            return new PKCS10CertificationRequest(((com.timevale.tgtext.bouncycastle.jce.PKCS10CertificationRequest)o2).getEncoded());
        }
        return o2;
    }
}

