/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.operator.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.OperatorStreamException;
import com.timevale.tgtext.bouncycastle.operator.RuntimeOperatorException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;

public class JcaContentSignerBuilder {
    private com.timevale.tgtext.bouncycastle.operator.jcajce.a helper = new com.timevale.tgtext.bouncycastle.operator.jcajce.a(new DefaultJcaJceHelper());
    private SecureRandom random;
    private String signatureAlgorithm;
    private AlgorithmIdentifier sigAlgId;

    public JcaContentSignerBuilder(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(signatureAlgorithm);
    }

    public JcaContentSignerBuilder setProvider(Provider provider) {
        this.helper = new com.timevale.tgtext.bouncycastle.operator.jcajce.a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentSignerBuilder setProvider(String providerName) {
        this.helper = new com.timevale.tgtext.bouncycastle.operator.jcajce.a(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcaContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(PrivateKey privateKey) throws OperatorCreationException {
        try {
            final Signature sig = this.helper.b(this.sigAlgId);
            if (this.random != null) {
                sig.initSign(privateKey, this.random);
            } else {
                sig.initSign(privateKey);
            }
            return new ContentSigner(){
                private a c;
                {
                    this.c = new a(sig);
                }

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return JcaContentSignerBuilder.this.sigAlgId;
                }

                @Override
                public OutputStream getOutputStream() {
                    return this.c;
                }

                @Override
                public byte[] getSignature() {
                    try {
                        return this.c.a();
                    }
                    catch (SignatureException e2) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + e2.getMessage(), e2);
                    }
                }
            };
        }
        catch (GeneralSecurityException e2) {
            throw new OperatorCreationException("cannot create signer: " + e2.getMessage(), e2);
        }
    }

    private class a
    extends OutputStream {
        private Signature b;

        a(Signature sig) {
            this.b = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.b.update(bytes, off, len);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.b.update(bytes);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(int b2) throws IOException {
            try {
                this.b.update((byte)b2);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        byte[] a() throws SignatureException {
            return this.b.sign();
        }
    }
}

