/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.math.BigInteger;

public class McEliecePublicKey
extends ASN1Object {
    private ASN1ObjectIdentifier oid;
    private int n;
    private int t;
    private byte[] matrixG;

    public McEliecePublicKey(ASN1ObjectIdentifier oid, int n2, int t2, GF2Matrix g2) {
        this.oid = oid;
        this.n = n2;
        this.t = t2;
        this.matrixG = g2.getEncoded();
    }

    private McEliecePublicKey(ASN1Sequence seq) {
        this.oid = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        BigInteger bigN = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        this.n = bigN.intValue();
        BigInteger bigT = ((ASN1Integer)seq.getObjectAt(2)).getValue();
        this.t = bigT.intValue();
        this.matrixG = ((ASN1OctetString)seq.getObjectAt(3)).getOctets();
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public GF2Matrix getG() {
        return new GF2Matrix(this.matrixG);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.oid);
        v2.add(new ASN1Integer(this.n));
        v2.add(new ASN1Integer(this.t));
        v2.add(new DEROctetString(this.matrixG));
        return new DERSequence(v2);
    }

    public static McEliecePublicKey getInstance(Object o2) {
        if (o2 instanceof McEliecePublicKey) {
            return (McEliecePublicKey)o2;
        }
        if (o2 != null) {
            return new McEliecePublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

