/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class McElieceKeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePublicKey) {
            BCMcEliecePublicKey k2 = (BCMcEliecePublicKey)key;
            return new McEliecePublicKeyParameters(k2.getOIDString(), k2.getN(), k2.getT(), k2.getG(), k2.getMcElieceParameters());
        }
        throw new InvalidKeyException("can't identify McEliece public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePrivateKey) {
            BCMcEliecePrivateKey k2 = (BCMcEliecePrivateKey)key;
            return new McEliecePrivateKeyParameters(k2.getOIDString(), k2.getN(), k2.getK(), k2.getField(), k2.getGoppaPoly(), k2.getSInv(), k2.getP1(), k2.getP2(), k2.getH(), k2.getQInv(), k2.getMcElieceParameters());
        }
        throw new InvalidKeyException("can't identify McEliece private key.");
    }
}

