/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.security;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;

public class d {
    public static CRL a(X509Certificate certificate) throws CertificateException, CRLException, IOException {
        return d.a(d.b(certificate));
    }

    public static String b(X509Certificate certificate) throws CertificateParsingException {
        DistributionPoint[] dists;
        ASN1Primitive obj;
        try {
            obj = d.a(certificate, Extension.cRLDistributionPoints.getId());
        }
        catch (IOException iOException) {
            obj = null;
        }
        if (obj == null) {
            return null;
        }
        CRLDistPoint dist = CRLDistPoint.getInstance(obj);
        DistributionPoint[] distributionPointArray = dists = dist.getDistributionPoints();
        int n2 = dists.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            GeneralName[] names;
            DistributionPoint p2 = distributionPointArray[i2];
            DistributionPointName distributionPointName = p2.getDistributionPoint();
            if (0 != distributionPointName.getType()) continue;
            GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
            GeneralName[] generalNameArray = names = generalNames.getNames();
            int n3 = names.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                GeneralName name = generalNameArray[i3];
                if (name.getTagNo() != 6) continue;
                DERIA5String derStr = DERIA5String.getInstance((ASN1TaggedObject)name.toASN1Primitive(), false);
                return derStr.getString();
            }
        }
        return null;
    }

    public static CRL a(String url) throws IOException, CertificateException, CRLException {
        if (url == null) {
            return null;
        }
        InputStream is = new URL(url).openStream();
        CertificateFactory cf2 = CertificateFactory.getInstance("X.509");
        return cf2.generateCRL(is);
    }

    public static String c(X509Certificate certificate) {
        try {
            ASN1Primitive obj = d.a(certificate, Extension.authorityInfoAccess.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence AccessDescriptions = (ASN1Sequence)obj;
            for (int i2 = 0; i2 < AccessDescriptions.size(); ++i2) {
                ASN1ObjectIdentifier id;
                ASN1Sequence AccessDescription2 = (ASN1Sequence)AccessDescriptions.getObjectAt(i2);
                if (AccessDescription2.size() != 2 || !(AccessDescription2.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !"1.3.6.1.5.5.7.48.1".equals((id = (ASN1ObjectIdentifier)AccessDescription2.getObjectAt(0)).getId())) continue;
                ASN1Primitive description = (ASN1Primitive)AccessDescription2.getObjectAt(1);
                String AccessLocation = d.a(description);
                if (AccessLocation == null) {
                    return "";
                }
                return AccessLocation;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    public static String d(X509Certificate certificate) {
        byte[] der = certificate.getExtensionValue("1.2.840.113583.1.1.9.1");
        if (der == null) {
            return null;
        }
        try {
            ASN1Primitive asn1obj = ASN1Primitive.fromByteArray(der);
            DEROctetString octets = (DEROctetString)asn1obj;
            asn1obj = ASN1Primitive.fromByteArray(octets.getOctets());
            ASN1Sequence asn1seq = ASN1Sequence.getInstance(asn1obj);
            return d.a(asn1seq.getObjectAt(1).toASN1Primitive());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ASN1Primitive a(X509Certificate certificate, String oid) throws IOException {
        byte[] bytes = certificate.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream(new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    private static String a(ASN1Primitive names) throws IOException {
        ASN1TaggedObject taggedObject = (ASN1TaggedObject)names;
        return new String(ASN1OctetString.getInstance(taggedObject, false).getOctets(), "ISO-8859-1");
    }
}

