/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.crypto.tls.ProtocolVersion;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsMac;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.SecureRandom;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected byte[] randomData;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsClientContext context, BlockCipher encryptCipher, BlockCipher decryptCipher, Digest writeDigest, Digest readDigest, int cipherKeySize) {
        this.context = context;
        this.randomData = new byte[256];
        context.getSecureRandom().nextBytes(this.randomData);
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        int key_block_size = 2 * cipherKeySize + writeDigest.getDigestSize() + readDigest.getDigestSize() + encryptCipher.getBlockSize() + decryptCipher.getBlockSize();
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        this.writeMac = new TlsMac(context, writeDigest, key_block, 0, writeDigest.getDigestSize());
        int offset = 0 + writeDigest.getDigestSize();
        this.readMac = new TlsMac(context, readDigest, key_block, offset, readDigest.getDigestSize());
        this.initCipher(true, encryptCipher, key_block, cipherKeySize, offset += readDigest.getDigestSize(), offset + (cipherKeySize << 1));
        this.initCipher(false, decryptCipher, key_block, cipherKeySize, offset += cipherKeySize, offset + cipherKeySize + encryptCipher.getBlockSize());
    }

    protected void initCipher(boolean forEncryption, BlockCipher cipher, byte[] key_block, int key_size, int key_offset, int iv_offset) {
        KeyParameter key_parameter = new KeyParameter(key_block, key_offset, key_size);
        ParametersWithIV parameters_with_iv = new ParametersWithIV(key_parameter, key_block, iv_offset, cipher.getBlockSize());
        cipher.init(forEncryption, parameters_with_iv);
    }

    @Override
    public byte[] encodePlaintext(short type, byte[] plaintext, int offset, int len) {
        int i2;
        int blocksize = this.encryptCipher.getBlockSize();
        int padding_length = blocksize - 1 - (len + this.writeMac.getSize()) % blocksize;
        boolean isTls = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (isTls) {
            int maxExtraPadBlocks = (255 - padding_length) / blocksize;
            int actualExtraPadBlocks = this.chooseExtraPadBlocks(this.context.getSecureRandom(), maxExtraPadBlocks);
            padding_length += actualExtraPadBlocks * blocksize;
        }
        int totalsize = len + this.writeMac.getSize() + padding_length + 1;
        byte[] outbuf = new byte[totalsize];
        System.arraycopy(plaintext, offset, outbuf, 0, len);
        byte[] mac = this.writeMac.calculateMac(type, plaintext, offset, len);
        System.arraycopy(mac, 0, outbuf, len, mac.length);
        int paddoffset = len + mac.length;
        for (i2 = 0; i2 <= padding_length; ++i2) {
            outbuf[i2 + paddoffset] = (byte)padding_length;
        }
        for (i2 = 0; i2 < totalsize; i2 += blocksize) {
            this.encryptCipher.processBlock(outbuf, i2, outbuf, i2);
        }
        return outbuf;
    }

    @Override
    public byte[] decodeCiphertext(short type, byte[] ciphertext, int offset, int len) throws IOException {
        int macSize;
        int blockSize = this.decryptCipher.getBlockSize();
        int minLen = Math.max(blockSize, (macSize = this.readMac.getSize()) + 1);
        if (len < minLen) {
            throw new TlsFatalAlert(50);
        }
        if (len % blockSize != 0) {
            throw new TlsFatalAlert(21);
        }
        for (int i2 = 0; i2 < len; i2 += blockSize) {
            this.decryptCipher.processBlock(ciphertext, offset + i2, ciphertext, offset + i2);
        }
        int totalPad = this.checkPaddingConstantTime(ciphertext, offset, len, blockSize, macSize);
        int macInputLen = len - totalPad - macSize;
        byte[] decryptedMac = Arrays.copyOfRange(ciphertext, offset + macInputLen, offset + macInputLen + macSize);
        byte[] calculatedMac = this.readMac.calculateMacConstantTime(type, ciphertext, offset, macInputLen, len - macSize, this.randomData);
        boolean badMac = !Arrays.constantTimeAreEqual(calculatedMac, decryptedMac);
        if (badMac || totalPad == 0) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(ciphertext, offset, offset + macInputLen);
    }

    protected int checkPaddingConstantTime(byte[] buf, int off, int len, int blockSize, int macSize) {
        int end = off + len;
        byte lastByte = buf[end - 1];
        int padlen = lastByte & 0xFF;
        int totalPad = padlen + 1;
        int dummyIndex = 0;
        int padDiff = 0;
        boolean isTls = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (!isTls && totalPad > blockSize || macSize + totalPad > len) {
            totalPad = 0;
        } else {
            int padPos = end - totalPad;
            do {
                padDiff = (byte)(padDiff | buf[padPos++] ^ lastByte);
            } while (padPos < end);
            dummyIndex = totalPad;
            if (padDiff != 0) {
                totalPad = 0;
            }
        }
        byte[] dummyPad = this.randomData;
        while (dummyIndex < 256) {
            padDiff = (byte)(padDiff | dummyPad[dummyIndex++] ^ lastByte);
        }
        dummyPad[0] = (byte)(dummyPad[0] ^ padDiff);
        return totalPad;
    }

    protected int chooseExtraPadBlocks(SecureRandom r2, int max) {
        int x2 = r2.nextInt();
        int n2 = this.lowestBitSet(x2);
        return Math.min(n2, max);
    }

    protected int lowestBitSet(int x2) {
        if (x2 == 0) {
            return 32;
        }
        int n2 = 0;
        while ((x2 & 1) == 0) {
            ++n2;
            x2 >>= 1;
        }
        return n2;
    }
}

