/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.BufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.engines.DESEngine;
import com.timevale.tgtext.bouncycastle.crypto.engines.DESedeEngine;
import com.timevale.tgtext.bouncycastle.crypto.engines.TwofishEngine;
import com.timevale.tgtext.bouncycastle.crypto.modes.CBCBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.CFBBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.CTSBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.OFBBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.crypto.params.RC2Parameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RC5Parameters;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.jce.provider.BrokenPBE;
import com.timevale.tgtext.bouncycastle.util.Strings;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class BrokenJCEBlockCipher
implements BrokenPBE {
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class, PBEParameterSpec.class, RC2ParameterSpec.class, RC5ParameterSpec.class};
    private BufferedBlockCipher cipher;
    private ParametersWithIV ivParam;
    private int pbeType = 2;
    private int pbeHash = 1;
    private int pbeKeySize;
    private int pbeIvSize;
    private int ivLength = 0;
    private AlgorithmParameters engineParams = null;

    protected BrokenJCEBlockCipher(BlockCipher engine) {
        this.cipher = new PaddedBufferedBlockCipher(engine);
    }

    protected BrokenJCEBlockCipher(BlockCipher engine, int pbeType, int pbeHash, int pbeKeySize, int pbeIvSize) {
        this.cipher = new PaddedBufferedBlockCipher(engine);
        this.pbeType = pbeType;
        this.pbeHash = pbeHash;
        this.pbeKeySize = pbeKeySize;
        this.pbeIvSize = pbeIvSize;
    }

    protected int engineGetBlockSize() {
        return this.cipher.getBlockSize();
    }

    protected byte[] engineGetIV() {
        if (this.ivParam != null) {
            return this.ivParam.getIV();
        }
        return null;
    }

    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.ivParam != null) {
            String name = this.cipher.getUnderlyingCipher().getAlgorithmName();
            if (name.indexOf(47) >= 0) {
                name = name.substring(0, name.indexOf(47));
            }
            try {
                this.engineParams = AlgorithmParameters.getInstance(name, BouncyCastleProvider.PROVIDER_NAME);
                this.engineParams.init(this.ivParam.getIV());
            }
            catch (Exception e2) {
                throw new RuntimeException(e2.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetMode(String mode) {
        String modeName = Strings.toUpperCase(mode);
        if (modeName.equals("ECB")) {
            this.ivLength = 0;
            this.cipher = new PaddedBufferedBlockCipher(this.cipher.getUnderlyingCipher());
            return;
        }
        if (modeName.equals("CBC")) {
            this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
            this.cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(this.cipher.getUnderlyingCipher()));
            return;
        }
        if (modeName.startsWith("OFB")) {
            this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
            if (modeName.length() != 3) {
                int wordSize = Integer.parseInt(modeName.substring(3));
                this.cipher = new PaddedBufferedBlockCipher(new OFBBlockCipher(this.cipher.getUnderlyingCipher(), wordSize));
                return;
            }
            this.cipher = new PaddedBufferedBlockCipher(new OFBBlockCipher(this.cipher.getUnderlyingCipher(), 8 * this.cipher.getBlockSize()));
            return;
        }
        if (modeName.startsWith("CFB")) {
            this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
            if (modeName.length() != 3) {
                int wordSize = Integer.parseInt(modeName.substring(3));
                this.cipher = new PaddedBufferedBlockCipher(new CFBBlockCipher(this.cipher.getUnderlyingCipher(), wordSize));
                return;
            }
            this.cipher = new PaddedBufferedBlockCipher(new CFBBlockCipher(this.cipher.getUnderlyingCipher(), 8 * this.cipher.getBlockSize()));
            return;
        }
        throw new IllegalArgumentException("can't support mode " + mode);
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        if (paddingName.equals("NOPADDING")) {
            this.cipher = new BufferedBlockCipher(this.cipher.getUnderlyingCipher());
            return;
        }
        if (paddingName.equals("PKCS5PADDING") || paddingName.equals("PKCS7PADDING") || paddingName.equals("ISO10126PADDING")) {
            this.cipher = new PaddedBufferedBlockCipher(this.cipher.getUnderlyingCipher());
            return;
        }
        if (paddingName.equals("WITHCTS")) {
            this.cipher = new CTSBlockCipher(this.cipher.getUnderlyingCipher());
            return;
        }
        throw new NoSuchPaddingException("Padding " + padding + " unknown.");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        if (key instanceof BCPBEKey) {
            param = BrokenPBE.Util.makePBEParameters((BCPBEKey)key, params, this.pbeType, this.pbeHash, this.cipher.getUnderlyingCipher().getAlgorithmName(), this.pbeKeySize, this.pbeIvSize);
            if (this.pbeIvSize != 0) {
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params == null) {
            param = new KeyParameter(key.getEncoded());
        } else if (params instanceof IvParameterSpec) {
            if (this.ivLength != 0) {
                param = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)params).getIV());
                this.ivParam = (ParametersWithIV)param;
            } else {
                param = new KeyParameter(key.getEncoded());
            }
        } else if (params instanceof RC2ParameterSpec) {
            RC2ParameterSpec rc2Param = (RC2ParameterSpec)params;
            param = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)params).getEffectiveKeyBits());
            if (rc2Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, rc2Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params instanceof RC5ParameterSpec) {
            RC5ParameterSpec rc5Param = (RC5ParameterSpec)params;
            param = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)params).getRounds());
            if (rc5Param.getWordSize() != 32) {
                throw new IllegalArgumentException("can only accept RC5 word size 32 (at the moment...)");
            }
            if (rc5Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, rc5Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(param instanceof ParametersWithIV)) {
            if (random == null) {
                random = new SecureRandom();
            }
            if (opmode == 1 || opmode == 3) {
                byte[] iv = new byte[this.ivLength];
                random.nextBytes(iv);
                param = new ParametersWithIV(param, iv);
                this.ivParam = (ParametersWithIV)param;
            } else {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        switch (opmode) {
            case 1: 
            case 3: {
                this.cipher.init(true, param);
                return;
            }
            case 2: 
            case 4: {
                this.cipher.init(false, param);
                return;
            }
        }
        System.out.println("eeek!");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineParams = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
            return;
        }
        catch (InvalidAlgorithmParameterException e2) {
            throw new IllegalArgumentException(e2.getMessage());
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        int length = this.cipher.getUpdateOutputSize(inputLen);
        if (length > 0) {
            byte[] out = new byte[length];
            this.cipher.processBytes(input, inputOffset, inputLen, out, 0);
            return out;
        }
        this.cipher.processBytes(input, inputOffset, inputLen, null, 0);
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        return this.cipher.processBytes(input, inputOffset, inputLen, output, outputOffset);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int len = 0;
        byte[] tmp = new byte[this.engineGetOutputSize(inputLen)];
        if (inputLen != 0) {
            len = this.cipher.processBytes(input, inputOffset, inputLen, tmp, 0);
        }
        try {
            len += this.cipher.doFinal(tmp, len);
        }
        catch (DataLengthException e2) {
            throw new IllegalBlockSizeException(e2.getMessage());
        }
        catch (InvalidCipherTextException e3) {
            throw new BadPaddingException(e3.getMessage());
        }
        byte[] out = new byte[len];
        System.arraycopy(tmp, 0, out, 0, len);
        return out;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        int len = 0;
        if (inputLen != 0) {
            len = this.cipher.processBytes(input, inputOffset, inputLen, output, outputOffset);
        }
        try {
            return len + this.cipher.doFinal(output, outputOffset + len);
        }
        catch (DataLengthException e2) {
            throw new IllegalBlockSizeException(e2.getMessage());
        }
        catch (InvalidCipherTextException e3) {
            throw new BadPaddingException(e3.getMessage());
        }
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e2) {
            throw new IllegalBlockSizeException(e2.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        byte[] encoded;
        try {
            encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
        catch (IllegalBlockSizeException e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
        if (wrappedKeyType == 3) {
            return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
        }
        try {
            KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm, BouncyCastleProvider.PROVIDER_NAME);
            if (wrappedKeyType == 1) {
                return kf.generatePublic(new X509EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 2) {
                return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
        }
        catch (NoSuchProviderException e3) {
            throw new InvalidKeyException("Unknown key type " + e3.getMessage());
        }
        catch (NoSuchAlgorithmException e4) {
            throw new InvalidKeyException("Unknown key type " + e4.getMessage());
        }
        catch (InvalidKeySpecException e2) {
            throw new InvalidKeyException("Unknown key type " + e2.getMessage());
        }
        throw new InvalidKeyException("Unknown key type " + wrappedKeyType);
    }

    public static class OldPBEWithSHAAndTwofish
    extends BrokenJCEBlockCipher {
        public OldPBEWithSHAAndTwofish() {
            super(new CBCBlockCipher(new TwofishEngine()), 3, 1, 256, 128);
        }
    }

    public static class BrokePBEWithSHAAndDES2Key
    extends BrokenJCEBlockCipher {
        public BrokePBEWithSHAAndDES2Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 2, 1, 128, 64);
        }
    }

    public static class OldPBEWithSHAAndDES3Key
    extends BrokenJCEBlockCipher {
        public OldPBEWithSHAAndDES3Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 3, 1, 192, 64);
        }
    }

    public static class BrokePBEWithSHAAndDES3Key
    extends BrokenJCEBlockCipher {
        public BrokePBEWithSHAAndDES3Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 2, 1, 192, 64);
        }
    }

    public static class BrokePBEWithSHA1AndDES
    extends BrokenJCEBlockCipher {
        public BrokePBEWithSHA1AndDES() {
            super(new CBCBlockCipher(new DESEngine()), 0, 1, 64, 64);
        }
    }

    public static class BrokePBEWithMD5AndDES
    extends BrokenJCEBlockCipher {
        public BrokePBEWithMD5AndDES() {
            super(new CBCBlockCipher(new DESEngine()), 0, 0, 64, 64);
        }
    }
}

