/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ParSet
extends ASN1Object {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private int t;
    private int[] h;
    private int[] w;
    private int[] k;

    private static int checkBigIntegerInIntRangeAndPositive(BigInteger b2) {
        if (b2.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || b2.compareTo(ZERO) <= 0) {
            throw new IllegalArgumentException("BigInteger not in Range: " + b2.toString());
        }
        return b2.intValue();
    }

    private ParSet(ASN1Sequence seq) {
        if (seq.size() != 4) {
            throw new IllegalArgumentException("sie of seqOfParams = " + seq.size());
        }
        BigInteger asn1int = ((ASN1Integer)seq.getObjectAt(0)).getValue();
        this.t = ParSet.checkBigIntegerInIntRangeAndPositive(asn1int);
        ASN1Sequence seqOfPSh = (ASN1Sequence)seq.getObjectAt(1);
        ASN1Sequence seqOfPSw = (ASN1Sequence)seq.getObjectAt(2);
        ASN1Sequence seqOfPSK = (ASN1Sequence)seq.getObjectAt(3);
        if (seqOfPSh.size() != this.t || seqOfPSw.size() != this.t || seqOfPSK.size() != this.t) {
            throw new IllegalArgumentException("invalid size of sequences");
        }
        this.h = new int[seqOfPSh.size()];
        this.w = new int[seqOfPSw.size()];
        this.k = new int[seqOfPSK.size()];
        for (int i2 = 0; i2 < this.t; ++i2) {
            this.h[i2] = ParSet.checkBigIntegerInIntRangeAndPositive(((ASN1Integer)seqOfPSh.getObjectAt(i2)).getValue());
            this.w[i2] = ParSet.checkBigIntegerInIntRangeAndPositive(((ASN1Integer)seqOfPSw.getObjectAt(i2)).getValue());
            this.k[i2] = ParSet.checkBigIntegerInIntRangeAndPositive(((ASN1Integer)seqOfPSK.getObjectAt(i2)).getValue());
        }
    }

    public ParSet(int t2, int[] h2, int[] w2, int[] k2) {
        this.t = t2;
        this.h = h2;
        this.w = w2;
        this.k = k2;
    }

    public static ParSet getInstance(Object o2) {
        if (o2 instanceof ParSet) {
            return (ParSet)o2;
        }
        if (o2 != null) {
            return new ParSet(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public int getT() {
        return this.t;
    }

    public int[] getH() {
        return Arrays.clone(this.h);
    }

    public int[] getW() {
        return Arrays.clone(this.w);
    }

    public int[] getK() {
        return Arrays.clone(this.k);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector seqOfPSh = new ASN1EncodableVector();
        ASN1EncodableVector seqOfPSw = new ASN1EncodableVector();
        ASN1EncodableVector seqOfPSK = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            seqOfPSh.add(new ASN1Integer(this.h[i2]));
            seqOfPSw.add(new ASN1Integer(this.w[i2]));
            seqOfPSK.add(new ASN1Integer(this.k[i2]));
        }
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new ASN1Integer(this.t));
        v2.add(new DERSequence(seqOfPSh));
        v2.add(new DERSequence(seqOfPSw));
        v2.add(new DERSequence(seqOfPSK));
        return new DERSequence(v2);
    }
}

