/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1String;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.i;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;

public class DERBMPString
extends ASN1Primitive
implements ASN1String {
    private char[] string;

    public static DERBMPString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBMPString) {
            return (DERBMPString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERBMPString)DERBMPString.fromByteArray((byte[])obj);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERBMPString) {
            return DERBMPString.getInstance(o2);
        }
        return new DERBMPString(ASN1OctetString.getInstance(o2).getOctets());
    }

    DERBMPString(byte[] string) {
        char[] cs2 = new char[string.length / 2];
        for (int i2 = 0; i2 != cs2.length; ++i2) {
            cs2[i2] = (char)(string[2 * i2] << 8 | string[2 * i2 + 1] & 0xFF);
        }
        this.string = cs2;
    }

    DERBMPString(char[] string) {
        this.string = string;
    }

    public DERBMPString(String string) {
        this.string = string.toCharArray();
    }

    @Override
    public String getString() {
        return new String(this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERBMPString)) {
            return false;
        }
        DERBMPString s2 = (DERBMPString)o2;
        return Arrays.areEqual(this.string, s2.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + i.a(this.string.length << 1) + (this.string.length << 1);
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.write(30);
        out.writeLength(this.string.length << 1);
        for (int i2 = 0; i2 != this.string.length; ++i2) {
            char c2 = this.string[i2];
            out.write((byte)(c2 >> 8));
            out.write((byte)c2);
        }
    }
}

