/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Vector;
import java.security.SecureRandom;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] enc) {
        if (enc.length < 9) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.numRows = LittleEndianConversions.OS2IP(enc, 0);
        this.numColumns = LittleEndianConversions.OS2IP(enc, 4);
        int n2 = (this.numColumns + 7 >>> 3) * this.numRows;
        if (this.numRows <= 0 || n2 != enc.length - 8) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.length = this.numColumns + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int q2 = this.numColumns >> 5;
        int r2 = this.numColumns & 0x1F;
        int count = 8;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int j2 = 0;
            while (j2 < q2) {
                this.matrix[i2][j2] = LittleEndianConversions.OS2IP(enc, count);
                ++j2;
                count += 4;
            }
            for (j2 = 0; j2 < r2; j2 += 8) {
                int[] nArray = this.matrix[i2];
                int n3 = q2;
                nArray[n3] = nArray[n3] ^ (enc[count++] & 0xFF) << j2;
            }
        }
    }

    public GF2Matrix(int numColumns, int[][] matrix) {
        if (matrix[0].length != numColumns + 31 >> 5) {
            throw new ArithmeticException("Int array does not match given number of columns.");
        }
        this.numColumns = numColumns;
        this.numRows = matrix.length;
        this.length = matrix[0].length;
        int rest = numColumns & 0x1F;
        int bitMask = rest == 0 ? -1 : (1 << rest) - 1;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int[] nArray = matrix[i2];
            int n2 = this.length - 1;
            nArray[n2] = nArray[n2] & bitMask;
        }
        this.matrix = matrix;
    }

    public GF2Matrix(int n2, char typeOfMatrix) {
        this(n2, typeOfMatrix, new SecureRandom());
    }

    public GF2Matrix(int n2, char typeOfMatrix, SecureRandom sr) {
        if (n2 <= 0) {
            throw new ArithmeticException("Size of matrix is non-positive.");
        }
        switch (typeOfMatrix) {
            case 'Z': {
                this.assignZeroMatrix(n2, n2);
                return;
            }
            case 'I': {
                this.assignUnitMatrix(n2);
                return;
            }
            case 'L': {
                this.assignRandomLowerTriangularMatrix(n2, sr);
                return;
            }
            case 'U': {
                this.assignRandomUpperTriangularMatrix(n2, sr);
                return;
            }
            case 'R': {
                this.assignRandomRegularMatrix(n2, sr);
                return;
            }
        }
        throw new ArithmeticException("Unknown matrix type.");
    }

    public GF2Matrix(GF2Matrix a2) {
        this.numColumns = a2.getNumColumns();
        this.numRows = a2.getNumRows();
        this.length = a2.length;
        this.matrix = new int[a2.matrix.length][];
        for (int i2 = 0; i2 < this.matrix.length; ++i2) {
            this.matrix[i2] = IntUtils.clone(a2.matrix[i2]);
        }
    }

    private GF2Matrix(int m2, int n2) {
        if (n2 <= 0 || m2 <= 0) {
            throw new ArithmeticException("size of matrix is non-positive");
        }
        this.assignZeroMatrix(m2, n2);
    }

    private void assignZeroMatrix(int m2, int n2) {
        this.numRows = m2;
        this.numColumns = n2;
        this.length = n2 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.length; ++j2) {
                this.matrix[i2][j2] = 0;
            }
        }
    }

    private void assignUnitMatrix(int n2) {
        int i2;
        this.numRows = n2;
        this.numColumns = n2;
        this.length = n2 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.length; ++j2) {
                this.matrix[i2][j2] = 0;
            }
        }
        for (i2 = 0; i2 < this.numRows; ++i2) {
            int rest = i2 & 0x1F;
            this.matrix[i2][i2 >>> 5] = 1 << rest;
        }
    }

    private void assignRandomLowerTriangularMatrix(int n2, SecureRandom sr) {
        this.numRows = n2;
        this.numColumns = n2;
        this.length = n2 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int j2;
            int q2 = i2 >>> 5;
            int r2 = i2 & 0x1F;
            int s2 = 31 - r2;
            r2 = 1 << r2;
            for (j2 = 0; j2 < q2; ++j2) {
                this.matrix[i2][j2] = sr.nextInt();
            }
            this.matrix[i2][q2] = sr.nextInt() >>> s2 | r2;
            for (j2 = q2 + 1; j2 < this.length; ++j2) {
                this.matrix[i2][j2] = 0;
            }
        }
    }

    private void assignRandomUpperTriangularMatrix(int n2, SecureRandom sr) {
        this.numRows = n2;
        this.numColumns = n2;
        this.length = n2 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int rest = n2 & 0x1F;
        int help = rest == 0 ? -1 : (1 << rest) - 1;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int j2;
            int r2;
            int q2 = i2 >>> 5;
            int s2 = r2 = i2 & 0x1F;
            r2 = 1 << r2;
            for (j2 = 0; j2 < q2; ++j2) {
                this.matrix[i2][j2] = 0;
            }
            this.matrix[i2][q2] = sr.nextInt() << s2 | r2;
            for (j2 = q2 + 1; j2 < this.length; ++j2) {
                this.matrix[i2][j2] = sr.nextInt();
            }
            int[] nArray = this.matrix[i2];
            int n3 = this.length - 1;
            nArray[n3] = nArray[n3] & help;
        }
    }

    private void assignRandomRegularMatrix(int n2, SecureRandom sr) {
        this.numRows = n2;
        this.numColumns = n2;
        this.length = n2 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        GF2Matrix lm = new GF2Matrix(n2, 'L', sr);
        GF2Matrix um = new GF2Matrix(n2, 'U', sr);
        GF2Matrix rm = (GF2Matrix)lm.rightMultiply(um);
        Permutation perm = new Permutation(n2, sr);
        int[] p2 = perm.getVector();
        for (int i2 = 0; i2 < n2; ++i2) {
            System.arraycopy(rm.matrix[i2], 0, this.matrix[p2[i2]], 0, this.length);
        }
    }

    public static GF2Matrix[] createRandomRegularMatrixAndItsInverse(int n2, SecureRandom sr) {
        GF2Matrix[] result = new GF2Matrix[2];
        int length = n2 + 31 >> 5;
        GF2Matrix lm = new GF2Matrix(n2, 'L', sr);
        GF2Matrix um = new GF2Matrix(n2, 'U', sr);
        GF2Matrix rm = (GF2Matrix)lm.rightMultiply(um);
        Permutation p2 = new Permutation(n2, sr);
        int[] pVec = p2.getVector();
        int[][] matrix = new int[n2][length];
        for (int i2 = 0; i2 < n2; ++i2) {
            System.arraycopy(rm.matrix[pVec[i2]], 0, matrix[i2], 0, length);
        }
        result[0] = new GF2Matrix(n2, matrix);
        GF2Matrix invLm = new GF2Matrix(n2, 'I');
        for (int i3 = 0; i3 < n2; ++i3) {
            int rest = i3 & 0x1F;
            int q2 = i3 >>> 5;
            int r2 = 1 << rest;
            for (int j2 = i3 + 1; j2 < n2; ++j2) {
                int b2 = lm.matrix[j2][q2] & r2;
                if (b2 == 0) continue;
                for (int k2 = 0; k2 <= q2; ++k2) {
                    int[] nArray = invLm.matrix[j2];
                    int n3 = k2;
                    nArray[n3] = nArray[n3] ^ invLm.matrix[i3][k2];
                }
            }
        }
        GF2Matrix invUm = new GF2Matrix(n2, 'I');
        for (int i4 = n2 - 1; i4 >= 0; --i4) {
            int rest = i4 & 0x1F;
            int q3 = i4 >>> 5;
            int r3 = 1 << rest;
            for (int j3 = i4 - 1; j3 >= 0; --j3) {
                int b3 = um.matrix[j3][q3] & r3;
                if (b3 == 0) continue;
                for (int k3 = q3; k3 < length; ++k3) {
                    int[] nArray = invUm.matrix[j3];
                    int n4 = k3;
                    nArray[n4] = nArray[n4] ^ invUm.matrix[i4][k3];
                }
            }
        }
        result[1] = (GF2Matrix)invUm.rightMultiply(invLm.rightMultiply(p2));
        return result;
    }

    public int[][] getIntArray() {
        return this.matrix;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getRow(int index) {
        return this.matrix[index];
    }

    @Override
    public byte[] getEncoded() {
        int n2 = this.numColumns + 7 >>> 3;
        n2 *= this.numRows;
        byte[] enc = new byte[n2 += 8];
        LittleEndianConversions.I2OSP(this.numRows, enc, 0);
        LittleEndianConversions.I2OSP(this.numColumns, enc, 4);
        int q2 = this.numColumns >>> 5;
        int r2 = this.numColumns & 0x1F;
        int count = 8;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int j2 = 0;
            while (j2 < q2) {
                LittleEndianConversions.I2OSP(this.matrix[i2][j2], enc, count);
                ++j2;
                count += 4;
            }
            for (j2 = 0; j2 < r2; j2 += 8) {
                enc[count++] = (byte)(this.matrix[i2][q2] >>> j2);
            }
        }
        return enc;
    }

    public double getHammingWeight() {
        double counter = 0.0;
        double elementCounter = 0.0;
        int rest = this.numColumns & 0x1F;
        int d2 = rest == 0 ? this.length : this.length - 1;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < d2; ++j2) {
                int a2 = this.matrix[i2][j2];
                for (int k2 = 0; k2 < 32; ++k2) {
                    int b2 = a2 >>> k2 & 1;
                    counter += (double)b2;
                    elementCounter += 1.0;
                }
            }
            int a3 = this.matrix[i2][this.length - 1];
            for (int k3 = 0; k3 < rest; ++k3) {
                int b3 = a3 >>> k3 & 1;
                counter += (double)b3;
                elementCounter += 1.0;
            }
        }
        return counter / elementCounter;
    }

    @Override
    public boolean isZero() {
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.length; ++j2) {
                if (this.matrix[i2][j2] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public GF2Matrix getLeftSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int length = this.numRows + 31 >> 5;
        int[][] result = new int[this.numRows][length];
        int bitMask = (1 << (this.numRows & 0x1F)) - 1;
        if (bitMask == 0) {
            bitMask = -1;
        }
        for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
            System.arraycopy(this.matrix[i2], 0, result[i2], 0, length);
            int[] nArray = result[i2];
            int n2 = length - 1;
            nArray[n2] = nArray[n2] & bitMask;
        }
        return new GF2Matrix(this.numRows, result);
    }

    public GF2Matrix extendLeftCompactForm() {
        int newNumColumns = this.numColumns + this.numRows;
        GF2Matrix result = new GF2Matrix(this.numRows, newNumColumns);
        int ind = this.numRows - 1 + this.numColumns;
        int i2 = this.numRows - 1;
        while (i2 >= 0) {
            System.arraycopy(this.matrix[i2], 0, result.matrix[i2], 0, this.length);
            int[] nArray = result.matrix[i2];
            int n2 = ind >> 5;
            nArray[n2] = nArray[n2] | 1 << (ind & 0x1F);
            --i2;
            --ind;
        }
        return result;
    }

    public GF2Matrix getRightSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int q2 = this.numRows >> 5;
        int r2 = this.numRows & 0x1F;
        GF2Matrix result = new GF2Matrix(this.numRows, this.numColumns - this.numRows);
        for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
            if (r2 != 0) {
                int ind = q2;
                for (int j2 = 0; j2 < result.length - 1; ++j2) {
                    result.matrix[i2][j2] = this.matrix[i2][ind++] >>> r2 | this.matrix[i2][ind] << 32 - r2;
                }
                result.matrix[i2][result.length - 1] = this.matrix[i2][ind++] >>> r2;
                if (ind >= this.length) continue;
                int[] nArray = result.matrix[i2];
                int n2 = result.length - 1;
                nArray[n2] = nArray[n2] | this.matrix[i2][ind] << 32 - r2;
                continue;
            }
            System.arraycopy(this.matrix[i2], q2, result.matrix[i2], 0, result.length);
        }
        return result;
    }

    public GF2Matrix extendRightCompactForm() {
        GF2Matrix result = new GF2Matrix(this.numRows, this.numRows + this.numColumns);
        int q2 = this.numRows >> 5;
        int r2 = this.numRows & 0x1F;
        for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
            int[] nArray = result.matrix[i2];
            int n2 = i2 >> 5;
            nArray[n2] = nArray[n2] | 1 << (i2 & 0x1F);
            if (r2 != 0) {
                int ind = q2;
                for (int j2 = 0; j2 < this.length - 1; ++j2) {
                    int mw = this.matrix[i2][j2];
                    int[] nArray2 = result.matrix[i2];
                    int n3 = ind++;
                    nArray2[n3] = nArray2[n3] | mw << r2;
                    int[] nArray3 = result.matrix[i2];
                    int n4 = ind;
                    nArray3[n4] = nArray3[n4] | mw >>> 32 - r2;
                }
                int mw = this.matrix[i2][this.length - 1];
                int[] nArray4 = result.matrix[i2];
                int n5 = ind++;
                nArray4[n5] = nArray4[n5] | mw << r2;
                if (ind >= result.length) continue;
                int[] nArray5 = result.matrix[i2];
                int n6 = ind;
                nArray5[n6] = nArray5[n6] | mw >>> 32 - r2;
                continue;
            }
            System.arraycopy(this.matrix[i2], 0, result.matrix[i2], q2, this.length);
        }
        return result;
    }

    public Matrix computeTranspose() {
        int[][] result = new int[this.numColumns][this.numRows + 31 >>> 5];
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                int qs = j2 >>> 5;
                int rs = j2 & 0x1F;
                int b2 = this.matrix[i2][qs] >>> rs & 1;
                int qt = i2 >>> 5;
                int rt = i2 & 0x1F;
                if (b2 != 1) continue;
                int[] nArray = result[j2];
                int n2 = qt;
                nArray[n2] = nArray[n2] | 1 << rt;
            }
        }
        return new GF2Matrix(this.numRows, result);
    }

    @Override
    public Matrix computeInverse() {
        int q2;
        int i2;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] tmpMatrix = new int[this.numRows][this.length];
        for (int i3 = this.numRows - 1; i3 >= 0; --i3) {
            tmpMatrix[i3] = IntUtils.clone(this.matrix[i3]);
        }
        int[][] invMatrix = new int[this.numRows][this.length];
        for (i2 = this.numRows - 1; i2 >= 0; --i2) {
            q2 = i2 >> 5;
            int r2 = i2 & 0x1F;
            invMatrix[i2][q2] = 1 << r2;
        }
        for (i2 = 0; i2 < this.numRows; ++i2) {
            q2 = i2 >> 5;
            int bitMask = 1 << (i2 & 0x1F);
            if ((tmpMatrix[i2][q2] & bitMask) == 0) {
                boolean foundNonZero = false;
                for (int j2 = i2 + 1; j2 < this.numRows; ++j2) {
                    if ((tmpMatrix[j2][q2] & bitMask) == 0) continue;
                    foundNonZero = true;
                    GF2Matrix.swapRows(tmpMatrix, i2, j2);
                    GF2Matrix.swapRows(invMatrix, i2, j2);
                    j2 = this.numRows;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            for (int j3 = this.numRows - 1; j3 >= 0; --j3) {
                if (j3 == i2 || (tmpMatrix[j3][q2] & bitMask) == 0) continue;
                GF2Matrix.addToRow(tmpMatrix[i2], tmpMatrix[j3], q2);
                GF2Matrix.addToRow(invMatrix[i2], invMatrix[j3], 0);
            }
        }
        return new GF2Matrix(this.numColumns, invMatrix);
    }

    public Matrix leftMultiply(Permutation p2) {
        int[] pVec = p2.getVector();
        if (pVec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[][] result = new int[this.numRows][];
        for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
            result[i2] = IntUtils.clone(this.matrix[pVec[i2]]);
        }
        return new GF2Matrix(this.numRows, result);
    }

    @Override
    public Vector leftMultiply(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v2 = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.length];
        int q2 = this.numRows >> 5;
        int r2 = 1 << (this.numRows & 0x1F);
        int row = 0;
        for (int i2 = 0; i2 < q2; ++i2) {
            int bitMask = 1;
            do {
                int b2;
                if ((b2 = v2[i2] & bitMask) != 0) {
                    for (int j2 = 0; j2 < this.length; ++j2) {
                        int n2 = j2;
                        res[n2] = res[n2] ^ this.matrix[row][j2];
                    }
                }
                ++row;
            } while ((bitMask <<= 1) != 0);
        }
        for (int bitMask = 1; bitMask != r2; bitMask <<= 1) {
            int b3 = v2[q2] & bitMask;
            if (b3 != 0) {
                for (int j3 = 0; j3 < this.length; ++j3) {
                    int n3 = j3;
                    res[n3] = res[n3] ^ this.matrix[row][j3];
                }
            }
            ++row;
        }
        return new GF2Vector(res, this.numColumns);
    }

    public Vector leftMultiplyLeftCompactForm(Vector vec) {
        int r2;
        int q2;
        int j2;
        int b2;
        int bitMask;
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v2 = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + this.numColumns + 31 >>> 5];
        int words = this.numRows >>> 5;
        int row = 0;
        for (int i2 = 0; i2 < words; ++i2) {
            bitMask = 1;
            do {
                if ((b2 = v2[i2] & bitMask) != 0) {
                    for (j2 = 0; j2 < this.length; ++j2) {
                        int n2 = j2;
                        res[n2] = res[n2] ^ this.matrix[row][j2];
                    }
                    q2 = this.numColumns + row >>> 5;
                    r2 = this.numColumns + row & 0x1F;
                    int n3 = q2;
                    res[n3] = res[n3] | 1 << r2;
                }
                ++row;
            } while ((bitMask <<= 1) != 0);
        }
        int rem = 1 << (this.numRows & 0x1F);
        for (bitMask = 1; bitMask != rem; bitMask <<= 1) {
            b2 = v2[words] & bitMask;
            if (b2 != 0) {
                for (j2 = 0; j2 < this.length; ++j2) {
                    int n4 = j2;
                    res[n4] = res[n4] ^ this.matrix[row][j2];
                }
                q2 = this.numColumns + row >>> 5;
                r2 = this.numColumns + row & 0x1F;
                int n5 = q2;
                res[n5] = res[n5] | 1 << r2;
            }
            ++row;
        }
        return new GF2Vector(res, this.numRows + this.numColumns);
    }

    @Override
    public Matrix rightMultiply(Matrix mat) {
        if (!(mat instanceof GF2Matrix)) {
            throw new ArithmeticException("matrix is not defined over GF(2)");
        }
        if (mat.numRows != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix a2 = (GF2Matrix)mat;
        GF2Matrix result = new GF2Matrix(this.numRows, mat.numColumns);
        int rest = this.numColumns & 0x1F;
        int d2 = rest == 0 ? this.length : this.length - 1;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int count = 0;
            for (int j2 = 0; j2 < d2; ++j2) {
                int e2 = this.matrix[i2][j2];
                for (int h2 = 0; h2 < 32; ++h2) {
                    int b2 = e2 & 1 << h2;
                    if (b2 != 0) {
                        for (int g2 = 0; g2 < a2.length; ++g2) {
                            int[] nArray = result.matrix[i2];
                            int n2 = g2;
                            nArray[n2] = nArray[n2] ^ a2.matrix[count][g2];
                        }
                    }
                    ++count;
                }
            }
            int e3 = this.matrix[i2][this.length - 1];
            for (int h3 = 0; h3 < rest; ++h3) {
                int b3 = e3 & 1 << h3;
                if (b3 != 0) {
                    for (int g3 = 0; g3 < a2.length; ++g3) {
                        int[] nArray = result.matrix[i2];
                        int n3 = g3;
                        nArray[n3] = nArray[n3] ^ a2.matrix[count][g3];
                    }
                }
                ++count;
            }
        }
        return result;
    }

    @Override
    public Matrix rightMultiply(Permutation p2) {
        int[] pVec = p2.getVector();
        if (pVec.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix result = new GF2Matrix(this.numRows, this.numColumns);
        for (int i2 = this.numColumns - 1; i2 >= 0; --i2) {
            int q2 = i2 >>> 5;
            int r2 = i2 & 0x1F;
            int pq = pVec[i2] >>> 5;
            int pr = pVec[i2] & 0x1F;
            for (int j2 = this.numRows - 1; j2 >= 0; --j2) {
                int[] nArray = result.matrix[j2];
                int n2 = q2;
                nArray[n2] = nArray[n2] | (this.matrix[j2][pq] >>> pr & 1) << r2;
            }
        }
        return result;
    }

    @Override
    public Vector rightMultiply(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v2 = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + 31 >>> 5];
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int help = 0;
            for (int j2 = 0; j2 < this.length; ++j2) {
                help ^= this.matrix[i2][j2] & v2[j2];
            }
            int bitValue = 0;
            for (int j3 = 0; j3 < 32; ++j3) {
                bitValue ^= help >>> j3 & 1;
            }
            if (bitValue != true) continue;
            int n2 = i2 >>> 5;
            res[n2] = res[n2] | 1 << (i2 & 0x1F);
        }
        return new GF2Vector(res, this.numRows);
    }

    public Vector rightMultiplyRightCompactForm(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numColumns + this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v2 = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + 31 >>> 5];
        int q2 = this.numRows >> 5;
        int r2 = this.numRows & 0x1F;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            int j2;
            int help = v2[i2 >> 5] >>> (i2 & 0x1F) & 1;
            int vInd = q2;
            if (r2 != 0) {
                int vw;
                for (j2 = 0; j2 < this.length - 1; ++j2) {
                    vw = v2[vInd++] >>> r2 | v2[vInd] << 32 - r2;
                    help ^= this.matrix[i2][j2] & vw;
                }
                vw = v2[vInd++] >>> r2;
                if (vInd < v2.length) {
                    vw |= v2[vInd] << 32 - r2;
                }
                help ^= this.matrix[i2][this.length - 1] & vw;
            } else {
                for (int j3 = 0; j3 < this.length; ++j3) {
                    help ^= this.matrix[i2][j3] & v2[vInd++];
                }
            }
            int bitValue = 0;
            for (j2 = 0; j2 < 32; ++j2) {
                bitValue ^= help & 1;
                help >>>= 1;
            }
            if (bitValue != true) continue;
            int n2 = i2 >> 5;
            res[n2] = res[n2] | 1 << (i2 & 0x1F);
        }
        return new GF2Vector(res, this.numRows);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GF2Matrix)) {
            return false;
        }
        GF2Matrix otherMatrix = (GF2Matrix)other;
        if (this.numRows != otherMatrix.numRows || this.numColumns != otherMatrix.numColumns || this.length != otherMatrix.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            if (IntUtils.equals(this.matrix[i2], otherMatrix.matrix[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            hash = hash * 31 + this.matrix[i2].hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        int rest = this.numColumns & 0x1F;
        int d2 = rest == 0 ? this.length : this.length - 1;
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            buf.append(i2 + ": ");
            for (int j2 = 0; j2 < d2; ++j2) {
                int a2 = this.matrix[i2][j2];
                for (int k2 = 0; k2 < 32; ++k2) {
                    int b2 = a2 >>> k2 & 1;
                    if (b2 == 0) {
                        buf.append('0');
                        continue;
                    }
                    buf.append('1');
                }
                buf.append(' ');
            }
            int a3 = this.matrix[i2][this.length - 1];
            for (int k3 = 0; k3 < rest; ++k3) {
                int b3 = a3 >>> k3 & 1;
                if (b3 == 0) {
                    buf.append('0');
                    continue;
                }
                buf.append('1');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    private static void swapRows(int[][] matrix, int first, int second) {
        int[] tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }

    private static void addToRow(int[] fromRow, int[] toRow, int startIndex) {
        for (int i2 = toRow.length - 1; i2 >= startIndex; --i2) {
            toRow[i2] = fromRow[i2] ^ toRow[i2];
        }
    }
}

