/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIBody;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIHeader;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIMessage;
import com.timevale.tgtext.bouncycastle.cert.CertIOException;
import java.io.IOException;

public class GeneralPKIMessage {
    private final PKIMessage pkiMessage;

    private static PKIMessage parseBytes(byte[] encoding) throws IOException {
        try {
            return PKIMessage.getInstance(ASN1Primitive.fromByteArray(encoding));
        }
        catch (ClassCastException e2) {
            throw new CertIOException("malformed data: " + e2.getMessage(), e2);
        }
        catch (IllegalArgumentException e3) {
            throw new CertIOException("malformed data: " + e3.getMessage(), e3);
        }
    }

    public GeneralPKIMessage(byte[] encoding) throws IOException {
        this(GeneralPKIMessage.parseBytes(encoding));
    }

    public GeneralPKIMessage(PKIMessage pkiMessage) {
        this.pkiMessage = pkiMessage;
    }

    public PKIHeader getHeader() {
        return this.pkiMessage.getHeader();
    }

    public PKIBody getBody() {
        return this.pkiMessage.getBody();
    }

    public boolean hasProtection() {
        return this.pkiMessage.getHeader().getProtectionAlg() != null;
    }

    public PKIMessage toASN1Structure() {
        return this.pkiMessage;
    }
}

