/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA224Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA256Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA384Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA512Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePKCSCipher;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.McElieceKeysToParams;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.util.AsymmetricBlockCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class McEliecePKCSCipherSpi
extends AsymmetricBlockCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private McEliecePKCSCipher cipher;

    public McEliecePKCSCipherSpi(Digest digest, McEliecePKCSCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
    }

    @Override
    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param = McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key);
        param = new ParametersWithRandom(param, sr);
        this.digest.reset();
        this.cipher.init(true, param);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    @Override
    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter param = McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        this.digest.reset();
        this.cipher.init(false, param);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    @Override
    protected byte[] messageEncrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = null;
        try {
            output = this.cipher.messageEncrypt(input);
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
        }
        return output;
    }

    @Override
    protected byte[] messageDecrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = null;
        try {
            output = this.cipher.messageDecrypt(input);
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
        }
        return output;
    }

    @Override
    public String getName() {
        return "McEliecePKCS";
    }

    @Override
    public int getKeySize(Key key) throws InvalidKeyException {
        McElieceKeyParameters mcElieceKeyParameters = key instanceof PublicKey ? (McElieceKeyParameters)McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key) : (McElieceKeyParameters)McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        return this.cipher.getKeySize(mcElieceKeyParameters);
    }

    public static class McEliecePKCS512
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS512() {
            super(new SHA512Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS384
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS384() {
            super(new SHA384Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS256
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS256() {
            super(new SHA256Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS224
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS224() {
            super(new SHA224Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS() {
            super(new SHA1Digest(), new McEliecePKCSCipher());
        }
    }
}

