/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.MessageEncryptor;

public class McElieceKobaraImaiDigestCipher {
    private final Digest messDigest;
    private final MessageEncryptor mcElieceCCA2Cipher;
    private boolean forEncrypting;

    public McElieceKobaraImaiDigestCipher(MessageEncryptor mcElieceCCA2Cipher, Digest messDigest) {
        this.mcElieceCCA2Cipher = mcElieceCCA2Cipher;
        this.messDigest = messDigest;
    }

    public void init(boolean forEncrypting, CipherParameters param) {
        this.forEncrypting = forEncrypting;
        AsymmetricKeyParameter k2 = param instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)param).getParameters() : (AsymmetricKeyParameter)param;
        if (forEncrypting && k2.isPrivate()) {
            throw new IllegalArgumentException("Encrypting Requires Public Key.");
        }
        if (!forEncrypting && !k2.isPrivate()) {
            throw new IllegalArgumentException("Decrypting Requires Private Key.");
        }
        this.reset();
        this.mcElieceCCA2Cipher.init(forEncrypting, param);
    }

    public byte[] messageEncrypt() {
        if (!this.forEncrypting) {
            throw new IllegalStateException("McElieceKobaraImaiDigestCipher not initialised for encrypting.");
        }
        byte[] hash = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hash, 0);
        byte[] enc = null;
        try {
            enc = this.mcElieceCCA2Cipher.messageEncrypt(hash);
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
        }
        return enc;
    }

    public byte[] messageDecrypt(byte[] ciphertext) {
        byte[] output = null;
        if (this.forEncrypting) {
            throw new IllegalStateException("McElieceKobaraImaiDigestCipher not initialised for decrypting.");
        }
        try {
            output = this.mcElieceCCA2Cipher.messageDecrypt(ciphertext);
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
        }
        return output;
    }

    public void update(byte b2) {
        this.messDigest.update(b2);
    }

    public void update(byte[] in, int off, int len) {
        this.messDigest.update(in, off, len);
    }

    public void reset() {
        this.messDigest.reset();
    }
}

