/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;

public class IDEAEngine
implements BlockCipher {
    protected static final int BLOCK_SIZE = 8;
    private int[] workingKey = null;
    private static final int MASK = 65535;
    private static final int BASE = 65537;

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(forEncryption, ((KeyParameter)params).getKey());
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to IDEA init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "IDEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.workingKey == null) {
            throw new IllegalStateException("IDEA engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        this.ideaFunc(this.workingKey, in, inOff, out, outOff);
        return 8;
    }

    @Override
    public void reset() {
    }

    private int bytesToWord(byte[] in, int inOff) {
        return (in[inOff] << 8 & 0xFF00) + (in[inOff + 1] & 0xFF);
    }

    private void wordToBytes(int word, byte[] out, int outOff) {
        out[outOff] = (byte)(word >>> 8);
        out[outOff + 1] = (byte)word;
    }

    private int mul(int x2, int y2) {
        int p2;
        x2 = x2 == 0 ? 65537 - y2 : (y2 == 0 ? 65537 - x2 : y2 - x2 + ((y2 = (p2 = x2 * y2) & 0xFFFF) < (x2 = p2 >>> 16) ? 1 : 0));
        return x2 & 0xFFFF;
    }

    private void ideaFunc(int[] workingKey, byte[] in, int inOff, byte[] out, int outOff) {
        int keyOff = 0;
        int x0 = this.bytesToWord(in, inOff);
        int x1 = this.bytesToWord(in, inOff + 2);
        int x2 = this.bytesToWord(in, inOff + 4);
        int x3 = this.bytesToWord(in, inOff + 6);
        for (int round = 0; round < 8; ++round) {
            x0 = this.mul(x0, workingKey[keyOff++]);
            x1 += workingKey[keyOff++];
            x2 += workingKey[keyOff++];
            x3 = this.mul(x3, workingKey[keyOff++]);
            int t0 = x1 &= 0xFFFF;
            int t1 = x2 &= 0xFFFF;
            x2 ^= x0;
            x1 ^= x3;
            x2 = this.mul(x2, workingKey[keyOff++]);
            x1 += x2;
            x1 &= 0xFFFF;
            x1 = this.mul(x1, workingKey[keyOff++]);
            x2 += x1;
            x0 ^= x1;
            x3 ^= (x2 &= 0xFFFF);
            x1 ^= t1;
            x2 ^= t0;
        }
        this.wordToBytes(this.mul(x0, workingKey[keyOff++]), out, outOff);
        this.wordToBytes(x2 + workingKey[keyOff++], out, outOff + 2);
        this.wordToBytes(x1 + workingKey[keyOff++], out, outOff + 4);
        this.wordToBytes(this.mul(x3, workingKey[keyOff]), out, outOff + 6);
    }

    private int[] expandKey(byte[] uKey) {
        int i2;
        int[] key = new int[52];
        if (uKey.length < 16) {
            byte[] tmp = new byte[16];
            System.arraycopy(uKey, 0, tmp, 16 - uKey.length, uKey.length);
            uKey = tmp;
        }
        for (i2 = 0; i2 < 8; ++i2) {
            key[i2] = this.bytesToWord(uKey, i2 << 1);
        }
        for (i2 = 8; i2 < 52; ++i2) {
            key[i2] = (i2 & 7) < 6 ? ((key[i2 - 7] & 0x7F) << 9 | key[i2 - 6] >> 7) & 0xFFFF : ((i2 & 7) == 6 ? ((key[i2 - 7] & 0x7F) << 9 | key[i2 - 14] >> 7) & 0xFFFF : ((key[i2 - 15] & 0x7F) << 9 | key[i2 - 14] >> 7) & 0xFFFF);
        }
        return key;
    }

    private int mulInv(int x2) {
        if (x2 < 2) {
            return x2;
        }
        int t0 = 1;
        int t1 = 65537 / x2;
        for (int y2 = 65537 % x2; y2 != 1; y2 %= x2) {
            int q2 = x2 / y2;
            t0 = t0 + t1 * q2 & 0xFFFF;
            if ((x2 %= y2) == 1) {
                return t0;
            }
            q2 = y2 / x2;
            t1 = t1 + t0 * q2 & 0xFFFF;
        }
        return 1 - t1 & 0xFFFF;
    }

    int addInv(int x2) {
        return 0 - x2 & 0xFFFF;
    }

    private int[] invertKey(int[] inKey) {
        int p2 = 52;
        int[] key = new int[52];
        int inOff = 0;
        ++inOff;
        int t1 = this.mulInv(inKey[0]);
        ++inOff;
        int t2 = this.addInv(inKey[1]);
        ++inOff;
        int t3 = this.addInv(inKey[2]);
        ++inOff;
        int t4 = this.mulInv(inKey[3]);
        --p2;
        key[51] = t4;
        --p2;
        key[50] = t3;
        --p2;
        key[49] = t2;
        --p2;
        key[48] = t1;
        for (int round = 1; round < 8; ++round) {
            t1 = inKey[inOff++];
            t2 = inKey[inOff++];
            key[--p2] = t2;
            key[--p2] = t1;
            t1 = this.mulInv(inKey[inOff++]);
            t2 = this.addInv(inKey[inOff++]);
            t3 = this.addInv(inKey[inOff++]);
            t4 = this.mulInv(inKey[inOff++]);
            key[--p2] = t4;
            key[--p2] = t2;
            key[--p2] = t3;
            key[--p2] = t1;
        }
        t1 = inKey[inOff++];
        t2 = inKey[inOff++];
        key[--p2] = t2;
        key[--p2] = t1;
        t1 = this.mulInv(inKey[inOff++]);
        t2 = this.addInv(inKey[inOff++]);
        t3 = this.addInv(inKey[inOff++]);
        t4 = this.mulInv(inKey[inOff]);
        key[--p2] = t4;
        key[--p2] = t3;
        key[--p2] = t2;
        key[--p2] = t1;
        return key;
    }

    private int[] generateWorkingKey(boolean forEncryption, byte[] userKey) {
        if (forEncryption) {
            return this.expandKey(userKey);
        }
        return this.invertKey(this.expandKey(userKey));
    }
}

