/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.engines.a;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.params.RSABlindingParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

public class RSABlindingEngine
implements AsymmetricBlockCipher {
    private a core = new a();
    private RSAKeyParameters key;
    private BigInteger blindingFactor;
    private boolean forEncryption;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        RSABlindingParameters p2;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            p2 = (RSABlindingParameters)rParam.getParameters();
        } else {
            p2 = (RSABlindingParameters)param;
        }
        this.core.a(forEncryption, p2.getPublicKey());
        this.forEncryption = forEncryption;
        this.key = p2.getPublicKey();
        this.blindingFactor = p2.getBlindingFactor();
    }

    @Override
    public int getInputBlockSize() {
        return this.core.a();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.b();
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        BigInteger msg = this.core.a(in, inOff, inLen);
        msg = this.forEncryption ? this.blindMessage(msg) : this.unblindMessage(msg);
        return this.core.a(msg);
    }

    private BigInteger blindMessage(BigInteger msg) {
        BigInteger blindMsg = this.blindingFactor;
        blindMsg = msg.multiply(blindMsg.modPow(this.key.getExponent(), this.key.getModulus()));
        blindMsg = blindMsg.mod(this.key.getModulus());
        return blindMsg;
    }

    private BigInteger unblindMessage(BigInteger blindedMsg) {
        BigInteger m2 = this.key.getModulus();
        BigInteger msg = blindedMsg;
        BigInteger blindFactorInverse = this.blindingFactor.modInverse(m2);
        msg = msg.multiply(blindFactorInverse);
        msg = msg.mod(m2);
        return msg;
    }
}

