/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.polynomial;

import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.TernaryPolynomial;
import com.timevale.tgtext.bouncycastle.util.Arrays;

public class LongPolynomial5 {
    private long[] coeffs;
    private int numCoeffs;

    public LongPolynomial5(IntegerPolynomial p2) {
        this.numCoeffs = p2.coeffs.length;
        this.coeffs = new long[(this.numCoeffs + 4) / 5];
        int cIdx = 0;
        int shift = 0;
        for (int i2 = 0; i2 < this.numCoeffs; ++i2) {
            int n2 = cIdx++;
            this.coeffs[n2] = this.coeffs[n2] | (long)p2.coeffs[i2] << shift;
            if ((shift += 12) < 60) continue;
            shift = 0;
        }
    }

    private LongPolynomial5(long[] coeffs, int numCoeffs) {
        this.coeffs = coeffs;
        this.numCoeffs = numCoeffs;
    }

    public LongPolynomial5 mult(TernaryPolynomial poly2) {
        int cIdx;
        long[][] prod = new long[5][this.coeffs.length + (poly2.size() + 4) / 5 - 1];
        int[] ones = poly2.getOnes();
        for (int idx = 0; idx != ones.length; ++idx) {
            int pIdx = ones[idx];
            int cIdx2 = pIdx / 5;
            int m2 = pIdx - cIdx2 * 5;
            for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
                prod[m2][cIdx2] = prod[m2][cIdx2] + this.coeffs[i2] & 0x7FF7FF7FF7FF7FFL;
                ++cIdx2;
            }
        }
        int[] negOnes = poly2.getNegOnes();
        for (int idx = 0; idx != negOnes.length; ++idx) {
            int pIdx = negOnes[idx];
            cIdx = pIdx / 5;
            int m3 = pIdx - cIdx * 5;
            for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
                prod[m3][cIdx] = 0x800800800800800L + prod[m3][cIdx] - this.coeffs[i3] & 0x7FF7FF7FF7FF7FFL;
                ++cIdx;
            }
        }
        long[] cCoeffs = Arrays.copyOf(prod[0], prod[0].length + 1);
        for (int m4 = 1; m4 <= 4; ++m4) {
            int shift = m4 * 12;
            int shift60 = 60 - shift;
            long mask = (1L << shift60) - 1L;
            int pLen = prod[m4].length;
            for (int i4 = 0; i4 < pLen; ++i4) {
                long upper = prod[m4][i4] >> shift60;
                long lower = prod[m4][i4] & mask;
                cCoeffs[i4] = cCoeffs[i4] + (lower << shift) & 0x7FF7FF7FF7FF7FFL;
                int nextIdx = i4 + 1;
                cCoeffs[nextIdx] = cCoeffs[nextIdx] + upper & 0x7FF7FF7FF7FF7FFL;
            }
        }
        int shift = 12 * (this.numCoeffs % 5);
        for (cIdx = this.coeffs.length - 1; cIdx < cCoeffs.length; ++cIdx) {
            int newIdx;
            long iCoeff;
            if (cIdx == this.coeffs.length - 1) {
                iCoeff = this.numCoeffs == 5 ? 0L : cCoeffs[cIdx] >> shift;
                newIdx = 0;
            } else {
                iCoeff = cCoeffs[cIdx];
                newIdx = cIdx * 5 - this.numCoeffs;
            }
            int base = newIdx / 5;
            int m5 = newIdx - base * 5;
            long lower = iCoeff << m5 * 12;
            long upper = iCoeff >> 12 * (5 - m5);
            cCoeffs[base] = cCoeffs[base] + lower & 0x7FF7FF7FF7FF7FFL;
            int base1 = base + 1;
            if (base1 >= this.coeffs.length) continue;
            cCoeffs[base1] = cCoeffs[base1] + upper & 0x7FF7FF7FF7FF7FFL;
        }
        return new LongPolynomial5(cCoeffs, this.numCoeffs);
    }

    public IntegerPolynomial toIntegerPolynomial() {
        int[] intCoeffs = new int[this.numCoeffs];
        int cIdx = 0;
        int shift = 0;
        for (int i2 = 0; i2 < this.numCoeffs; ++i2) {
            intCoeffs[i2] = (int)(this.coeffs[cIdx] >> shift & 0x7FFL);
            if ((shift += 12) < 60) continue;
            shift = 0;
            ++cIdx;
        }
        return new IntegerPolynomial(intCoeffs);
    }
}

