/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.gmss;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.pqc.asn1.GMSSPublicKey;
import com.timevale.tgtext.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.pqc.asn1.ParSet;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.spec.GMSSPublicKeySpec;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import java.security.PublicKey;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyBytes;
    private GMSSParameters gmssParameterSet;
    private GMSSParameters gmssParams;

    public BCGMSSPublicKey(byte[] pub, GMSSParameters gmssParameterSet) {
        this.gmssParameterSet = gmssParameterSet;
        this.publicKeyBytes = pub;
    }

    protected BCGMSSPublicKey(GMSSPublicKeySpec keySpec) {
        this(keySpec.getPublicKey(), keySpec.getParameters());
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters params) {
        this(params.getPublicKey(), params.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public GMSSParameters getParameterSet() {
        return this.gmssParameterSet;
    }

    public String toString() {
        String out = "GMSS public key : " + new String(Hex.encode(this.publicKeyBytes)) + "\nHeight of Trees: \n";
        for (int i2 = 0; i2 < this.gmssParameterSet.getHeightOfTrees().length; ++i2) {
            out = out + "Layer " + i2 + " : " + this.gmssParameterSet.getHeightOfTrees()[i2] + " WinternitzParameter: " + this.gmssParameterSet.getWinternitzParameter()[i2] + " K: " + this.gmssParameterSet.getK()[i2] + "\n";
        }
        return out;
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, (ASN1Encodable)new ParSet(this.gmssParameterSet.getNumOfLayers(), this.gmssParameterSet.getHeightOfTrees(), this.gmssParameterSet.getWinternitzParameter(), this.gmssParameterSet.getK()).toASN1Primitive()), new GMSSPublicKey(this.publicKeyBytes));
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

