/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class IntegerFunctions {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger FOUR = BigInteger.valueOf(4L);
    private static final int[] SMALL_PRIMES = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41};
    private static final long SMALL_PRIME_PRODUCT = 152125131763605L;
    private static SecureRandom sr = null;
    private static final int[] jacobiTable = new int[]{0, 1, 0, -1, 0, -1, 0, 1};

    private IntegerFunctions() {
    }

    public static int jacobi(BigInteger A, BigInteger B) {
        long k2 = 1L;
        if (B.equals(ZERO)) {
            BigInteger a2 = A.abs();
            if (a2.equals(ONE)) {
                return 1;
            }
            return 0;
        }
        if (!A.testBit(0) && !B.testBit(0)) {
            return 0;
        }
        BigInteger a3 = A;
        BigInteger b2 = B;
        if (b2.signum() == -1) {
            b2 = b2.negate();
            if (a3.signum() == -1) {
                k2 = -1L;
            }
        }
        BigInteger v2 = ZERO;
        while (!b2.testBit(0)) {
            v2 = v2.add(ONE);
            b2 = b2.divide(TWO);
        }
        if (v2.testBit(0)) {
            k2 *= (long)jacobiTable[a3.intValue() & 7];
        }
        if (a3.signum() < 0) {
            if (b2.testBit(1)) {
                k2 = -k2;
            }
            a3 = a3.negate();
        }
        while (a3.signum() != 0) {
            v2 = ZERO;
            while (!a3.testBit(0)) {
                v2 = v2.add(ONE);
                a3 = a3.divide(TWO);
            }
            if (v2.testBit(0)) {
                k2 *= (long)jacobiTable[b2.intValue() & 7];
            }
            if (a3.compareTo(b2) < 0) {
                BigInteger x2 = a3;
                a3 = b2;
                b2 = x2;
                if (a3.testBit(1) && b2.testBit(1)) {
                    k2 = -k2;
                }
            }
            a3 = a3.subtract(b2);
        }
        if (b2.equals(ONE)) {
            return (int)k2;
        }
        return 0;
    }

    public static BigInteger ressol(BigInteger a2, BigInteger p2) throws IllegalArgumentException {
        if (a2.compareTo(ZERO) < 0) {
            a2 = a2.add(p2);
        }
        if (a2.equals(ZERO)) {
            return ZERO;
        }
        if (p2.equals(TWO)) {
            return a2;
        }
        if (p2.testBit(0) && p2.testBit(1)) {
            if (IntegerFunctions.jacobi(a2, p2) == 1) {
                BigInteger v2 = p2.add(ONE);
                v2 = v2.shiftRight(2);
                return a2.modPow(v2, p2);
            }
            throw new IllegalArgumentException("No quadratic residue: " + a2 + ", " + p2);
        }
        BigInteger k2 = p2.subtract(ONE);
        long s2 = 0L;
        while (!k2.testBit(0)) {
            ++s2;
            k2 = k2.shiftRight(1);
        }
        k2 = k2.subtract(ONE);
        k2 = k2.shiftRight(1);
        BigInteger r2 = a2.modPow(k2, p2);
        BigInteger n2 = r2.multiply(r2).remainder(p2);
        n2 = n2.multiply(a2).remainder(p2);
        r2 = r2.multiply(a2).remainder(p2);
        if (n2.equals(ONE)) {
            return r2;
        }
        BigInteger z2 = TWO;
        while (IntegerFunctions.jacobi(z2, p2) == 1) {
            z2 = z2.add(ONE);
        }
        BigInteger v2 = k2;
        v2 = v2.multiply(TWO);
        v2 = v2.add(ONE);
        BigInteger c2 = z2.modPow(v2, p2);
        while (n2.compareTo(ONE) == 1) {
            k2 = n2;
            long t2 = s2;
            s2 = 0L;
            while (!k2.equals(ONE)) {
                k2 = k2.multiply(k2).mod(p2);
                ++s2;
            }
            if ((t2 -= s2) == 0L) {
                throw new IllegalArgumentException("No quadratic residue: " + a2 + ", " + p2);
            }
            v2 = ONE;
            for (long i2 = 0L; i2 < t2 - 1L; ++i2) {
                v2 = v2.shiftLeft(1);
            }
            c2 = c2.modPow(v2, p2);
            r2 = r2.multiply(c2).remainder(p2);
            c2 = c2.multiply(c2).remainder(p2);
            n2 = n2.multiply(c2).mod(p2);
        }
        return r2;
    }

    public static int gcd(int u2, int v2) {
        return BigInteger.valueOf(u2).gcd(BigInteger.valueOf(v2)).intValue();
    }

    public static int[] extGCD(int a2, int b2) {
        BigInteger ba2 = BigInteger.valueOf(a2);
        BigInteger bb2 = BigInteger.valueOf(b2);
        BigInteger[] bresult = IntegerFunctions.extgcd(ba2, bb2);
        int[] nArray = new int[3];
        int[] result = nArray;
        nArray[0] = bresult[0].intValue();
        result[1] = bresult[1].intValue();
        result[2] = bresult[2].intValue();
        return result;
    }

    public static BigInteger divideAndRound(BigInteger a2, BigInteger b2) {
        if (a2.signum() < 0) {
            return IntegerFunctions.divideAndRound(a2.negate(), b2).negate();
        }
        if (b2.signum() < 0) {
            return IntegerFunctions.divideAndRound(a2, b2.negate()).negate();
        }
        return a2.shiftLeft(1).add(b2).divide(b2.shiftLeft(1));
    }

    public static BigInteger[] divideAndRound(BigInteger[] a2, BigInteger b2) {
        BigInteger[] out = new BigInteger[a2.length];
        for (int i2 = 0; i2 < a2.length; ++i2) {
            out[i2] = IntegerFunctions.divideAndRound(a2[i2], b2);
        }
        return out;
    }

    public static int ceilLog(BigInteger a2) {
        int result = 0;
        BigInteger p2 = ONE;
        while (p2.compareTo(a2) < 0) {
            ++result;
            p2 = p2.shiftLeft(1);
        }
        return result;
    }

    public static int ceilLog(int a2) {
        int log = 0;
        int i2 = 1;
        while (i2 < a2) {
            i2 <<= 1;
            ++log;
        }
        return log;
    }

    public static int ceilLog256(int n2) {
        if (n2 == 0) {
            return 1;
        }
        int d2 = 0;
        for (int m2 = n2 < 0 ? -n2 : n2; m2 > 0; m2 >>>= 8) {
            ++d2;
        }
        return d2;
    }

    public static int ceilLog256(long n2) {
        if (n2 == 0L) {
            return 1;
        }
        int d2 = 0;
        for (long m2 = n2 < 0L ? -n2 : n2; m2 > 0L; m2 >>>= 8) {
            ++d2;
        }
        return d2;
    }

    public static int floorLog(BigInteger a2) {
        int result = -1;
        BigInteger p2 = ONE;
        while (p2.compareTo(a2) <= 0) {
            ++result;
            p2 = p2.shiftLeft(1);
        }
        return result;
    }

    public static int floorLog(int a2) {
        int h2 = 0;
        if (a2 <= 0) {
            return -1;
        }
        for (int p2 = a2 >>> 1; p2 > 0; p2 >>>= 1) {
            ++h2;
        }
        return h2;
    }

    public static int maxPower(int a2) {
        int h2 = 0;
        if (a2 != 0) {
            int p2 = 1;
            while ((a2 & p2) == 0) {
                ++h2;
                p2 <<= 1;
            }
        }
        return h2;
    }

    public static int bitCount(int a2) {
        int h2 = 0;
        while (a2 != 0) {
            h2 += a2 & 1;
            a2 >>>= 1;
        }
        return h2;
    }

    public static int order(int g2, int p2) {
        int b2 = g2 % p2;
        int j2 = 1;
        if (b2 == 0) {
            throw new IllegalArgumentException(g2 + " is not an element of Z/(" + p2 + "Z)^*; it is not meaningful to compute its order.");
        }
        while (b2 != 1) {
            b2 *= g2;
            if ((b2 %= p2) < 0) {
                b2 += p2;
            }
            ++j2;
        }
        return j2;
    }

    public static BigInteger reduceInto(BigInteger n2, BigInteger begin, BigInteger end) {
        return n2.subtract(begin).mod(end.subtract(begin)).add(begin);
    }

    public static int pow(int a2, int e2) {
        int result = 1;
        while (e2 > 0) {
            if ((e2 & 1) == 1) {
                result *= a2;
            }
            a2 *= a2;
            e2 >>>= 1;
        }
        return result;
    }

    public static long pow(long a2, int e2) {
        long result = 1L;
        while (e2 > 0) {
            if ((e2 & 1) == 1) {
                result *= a2;
            }
            a2 *= a2;
            e2 >>>= 1;
        }
        return result;
    }

    public static int modPow(int a2, int e2, int n2) {
        if (n2 <= 0 || n2 * n2 > Integer.MAX_VALUE || e2 < 0) {
            return 0;
        }
        int result = 1;
        a2 = (a2 % n2 + n2) % n2;
        while (e2 > 0) {
            if ((e2 & 1) == 1) {
                result = result * a2 % n2;
            }
            a2 = a2 * a2 % n2;
            e2 >>>= 1;
        }
        return result;
    }

    public static BigInteger[] extgcd(BigInteger a2, BigInteger b2) {
        BigInteger u2 = ONE;
        BigInteger v2 = ZERO;
        BigInteger d2 = a2;
        if (b2.signum() != 0) {
            BigInteger v1 = ZERO;
            BigInteger v3 = b2;
            while (v3.signum() != 0) {
                BigInteger[] tmp = d2.divideAndRemainder(v3);
                BigInteger q2 = tmp[0];
                BigInteger t3 = tmp[1];
                BigInteger t1 = u2.subtract(q2.multiply(v1));
                u2 = v1;
                d2 = v3;
                v1 = t1;
                v3 = t3;
            }
            v2 = d2.subtract(a2.multiply(u2)).divide(b2);
        }
        return new BigInteger[]{d2, u2, v2};
    }

    public static BigInteger leastCommonMultiple(BigInteger[] numbers) {
        int n2 = numbers.length;
        BigInteger result = numbers[0];
        for (int i2 = 1; i2 < n2; ++i2) {
            BigInteger gcd = result.gcd(numbers[i2]);
            result = result.multiply(numbers[i2]).divide(gcd);
        }
        return result;
    }

    public static long mod(long a2, long m2) {
        long result = a2 % m2;
        if (result < 0L) {
            result += m2;
        }
        return result;
    }

    public static int modInverse(int a2, int mod) {
        return BigInteger.valueOf(a2).modInverse(BigInteger.valueOf(mod)).intValue();
    }

    public static long modInverse(long a2, long mod) {
        return BigInteger.valueOf(a2).modInverse(BigInteger.valueOf(mod)).longValue();
    }

    public static int isPower(int a2, int p2) {
        if (a2 <= 0) {
            return -1;
        }
        int n2 = 0;
        int d2 = a2;
        while (d2 > 1) {
            if (d2 % p2 != 0) {
                return -1;
            }
            d2 /= p2;
            ++n2;
        }
        return n2;
    }

    public static int leastDiv(int a2) {
        if (a2 < 0) {
            a2 = -a2;
        }
        if (a2 == 0) {
            return 1;
        }
        if ((a2 & 1) == 0) {
            return 2;
        }
        for (int p2 = 3; p2 <= a2 / p2; p2 += 2) {
            if (a2 % p2 != 0) continue;
            return p2;
        }
        return a2;
    }

    public static boolean isPrime(int n2) {
        if (n2 < 2) {
            return false;
        }
        if (n2 == 2) {
            return true;
        }
        if ((n2 & 1) == 0) {
            return false;
        }
        if (n2 < 42) {
            for (int i2 = 0; i2 < SMALL_PRIMES.length; ++i2) {
                if (n2 != SMALL_PRIMES[i2]) continue;
                return true;
            }
        }
        if (n2 % 3 == 0 || n2 % 5 == 0 || n2 % 7 == 0 || n2 % 11 == 0 || n2 % 13 == 0 || n2 % 17 == 0 || n2 % 19 == 0 || n2 % 23 == 0 || n2 % 29 == 0 || n2 % 31 == 0 || n2 % 37 == 0 || n2 % 41 == 0) {
            return false;
        }
        return BigInteger.valueOf(n2).isProbablePrime(20);
    }

    public static boolean passesSmallPrimeTest(BigInteger candidate) {
        int[] smallPrime = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499};
        for (int i2 = 0; i2 < 239; ++i2) {
            if (!candidate.mod(BigInteger.valueOf(smallPrime[i2])).equals(ZERO)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static int nextSmallerPrime(int n) {
        if (n <= 2) {
            return 1;
        }
        if (n == 3) {
            return 2;
        }
        if ((n & 1) != 0) ** GOTO lbl-1000
        --n;
        while (n > 3 & IntegerFunctions.isPrime(n) == false) lbl-1000:
        // 2 sources

        {
            n -= 2;
        }
        return n;
    }

    public static BigInteger nextProbablePrime(BigInteger n2, int certainty) {
        if (n2.signum() < 0 || n2.signum() == 0 || n2.equals(ONE)) {
            return TWO;
        }
        BigInteger result = n2.add(ONE);
        if (!result.testBit(0)) {
            result = result.add(ONE);
        }
        while (true) {
            long r2;
            if (result.bitLength() > 6 && ((r2 = result.remainder(BigInteger.valueOf(152125131763605L)).longValue()) % 3L == 0L || r2 % 5L == 0L || r2 % 7L == 0L || r2 % 11L == 0L || r2 % 13L == 0L || r2 % 17L == 0L || r2 % 19L == 0L || r2 % 23L == 0L || r2 % 29L == 0L || r2 % 31L == 0L || r2 % 37L == 0L || r2 % 41L == 0L)) {
                result = result.add(TWO);
                continue;
            }
            if (result.bitLength() < 4) {
                return result;
            }
            if (result.isProbablePrime(certainty)) {
                return result;
            }
            result = result.add(TWO);
        }
    }

    public static BigInteger nextProbablePrime(BigInteger n2) {
        return IntegerFunctions.nextProbablePrime(n2, 20);
    }

    public static BigInteger nextPrime(long n2) {
        boolean found = false;
        long result = 0L;
        if (n2 <= 1L) {
            return BigInteger.valueOf(2L);
        }
        if (n2 == 2L) {
            return BigInteger.valueOf(3L);
        }
        for (long i2 = n2 + 1L + (n2 & 1L); i2 <= n2 << 1 && !found; i2 += 2L) {
            for (long j2 = 3L; j2 <= i2 >> 1 && !found; j2 += 2L) {
                if (i2 % j2 != 0L) continue;
                found = true;
            }
            if (found) {
                found = false;
                continue;
            }
            result = i2;
            found = true;
        }
        return BigInteger.valueOf(result);
    }

    public static BigInteger binomial(int n2, int t2) {
        BigInteger result = ONE;
        if (n2 == 0) {
            if (t2 == 0) {
                return result;
            }
            return ZERO;
        }
        if (t2 > n2 >>> 1) {
            t2 = n2 - t2;
        }
        for (int i2 = 1; i2 <= t2; ++i2) {
            result = result.multiply(BigInteger.valueOf(n2 - (i2 - 1))).divide(BigInteger.valueOf(i2));
        }
        return result;
    }

    public static BigInteger randomize(BigInteger upperBound) {
        if (sr == null) {
            sr = new SecureRandom();
        }
        return IntegerFunctions.randomize(upperBound, sr);
    }

    public static BigInteger randomize(BigInteger upperBound, SecureRandom prng) {
        int blen = upperBound.bitLength();
        BigInteger randomNum = BigInteger.valueOf(0L);
        if (prng == null) {
            prng = sr != null ? sr : new SecureRandom();
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            randomNum = new BigInteger(blen, prng);
            if (randomNum.compareTo(upperBound) >= 0) continue;
            return randomNum;
        }
        return randomNum.mod(upperBound);
    }

    public static BigInteger squareRoot(BigInteger a2) {
        if (a2.compareTo(ZERO) < 0) {
            throw new ArithmeticException("cannot extract root of negative number" + a2 + ".");
        }
        int bl2 = a2.bitLength();
        BigInteger result = ZERO;
        BigInteger remainder = ZERO;
        if ((bl2 & 1) != 0) {
            result = result.add(ONE);
            --bl2;
        }
        while (bl2 > 0) {
            remainder = remainder.multiply(FOUR);
            remainder = remainder.add(BigInteger.valueOf((a2.testBit(--bl2) ? 2 : 0) + (a2.testBit(--bl2) ? 1 : 0)));
            BigInteger b2 = result.multiply(FOUR).add(ONE);
            result = result.multiply(TWO);
            if (remainder.compareTo(b2) == -1) continue;
            result = result.add(ONE);
            remainder = remainder.subtract(b2);
        }
        return result;
    }

    public static float intRoot(int base, int root) {
        float gNew = base / root;
        float gOld = 0.0f;
        while ((double)Math.abs(gOld - gNew) > 1.0E-4) {
            float gPow = IntegerFunctions.floatPow(gNew, root);
            while (Float.isInfinite(gPow)) {
                gNew = (gNew + gOld) / 2.0f;
                gPow = IntegerFunctions.floatPow(gNew, root);
            }
            gOld = gNew;
            gNew = gOld - (gPow - (float)base) / ((float)root * IntegerFunctions.floatPow(gOld, root - 1));
        }
        return gNew;
    }

    public static float floatLog(float param) {
        double arg;
        double arg2 = arg = (double)((param - 1.0f) / (param + 1.0f));
        int counter = 1;
        float result = (float)arg;
        while (arg2 > 0.001) {
            result = (float)((double)result + 1.0 / (double)(counter += 2) * (arg2 *= arg * arg));
        }
        return result * 2.0f;
    }

    public static float floatPow(float f2, int i2) {
        float g2 = 1.0f;
        while (i2 > 0) {
            g2 *= f2;
            --i2;
        }
        return g2;
    }

    public static double log(double x2) {
        if (x2 > 0.0 && x2 < 1.0) {
            double d2 = 1.0 / x2;
            double result = -IntegerFunctions.log(d2);
            return result;
        }
        int tmp = 0;
        double tmp2 = 1.0;
        double d3 = x2;
        while (d3 > 2.0) {
            d3 /= 2.0;
            ++tmp;
            tmp2 *= 2.0;
        }
        double rem = x2 / tmp2;
        rem = IntegerFunctions.logBKM(rem);
        return (double)tmp + rem;
    }

    public static double log(long x2) {
        int tmp = IntegerFunctions.floorLog(BigInteger.valueOf(x2));
        long tmp2 = 1 << tmp;
        double rem = (double)x2 / (double)tmp2;
        rem = IntegerFunctions.logBKM(rem);
        return (double)tmp + rem;
    }

    private static double logBKM(double arg) {
        double[] ae2 = new double[]{1.0, 0.5849625007211562, 0.32192809488736235, 0.16992500144231237, 0.0874628412503394, 0.044394119358453436, 0.02236781302845451, 0.01122725542325412, 0.005624549193878107, 0.0028150156070540383, 0.0014081943928083889, 7.042690112466433E-4, 3.5217748030102726E-4, 1.7609948644250602E-4, 8.80524301221769E-5, 4.4026886827316716E-5, 2.2013611360340496E-5, 1.1006847667481442E-5, 5.503434330648604E-6, 2.751719789561283E-6, 1.375860550841138E-6, 6.879304394358497E-7, 3.4396526072176454E-7, 1.7198264061184464E-7, 8.599132286866321E-8, 4.299566207501687E-8, 2.1497831197679756E-8, 1.0748915638882709E-8, 5.374457829452062E-9, 2.687228917228708E-9, 1.3436144592400231E-9, 6.718072297764289E-10, 3.3590361492731876E-10, 1.6795180747343547E-10, 8.397590373916176E-11, 4.1987951870191886E-11, 2.0993975935248694E-11, 1.0496987967662534E-11, 5.2484939838408146E-12, 2.624246991922794E-12, 1.3121234959619935E-12, 6.56061747981146E-13, 3.2803087399061026E-13, 1.6401543699531447E-13, 8.200771849765956E-14, 4.1003859248830365E-14, 2.0501929624415328E-14, 1.02509648122077E-14, 5.1254824061038595E-15, 2.5627412030519317E-15, 1.2813706015259665E-15, 6.406853007629834E-16, 3.203426503814917E-16, 1.6017132519074588E-16, 8.008566259537294E-17, 4.004283129768647E-17, 2.0021415648843235E-17, 1.0010707824421618E-17, 5.005353912210809E-18, 2.5026769561054044E-18, 1.2513384780527022E-18, 6.256692390263511E-19, 3.1283461951317555E-19, 1.5641730975658778E-19, 7.820865487829389E-20, 3.9104327439146944E-20, 1.9552163719573472E-20, 9.776081859786736E-21, 4.888040929893368E-21, 2.444020464946684E-21, 1.222010232473342E-21, 6.11005116236671E-22, 3.055025581183355E-22, 1.5275127905916775E-22, 7.637563952958387E-23, 3.818781976479194E-23, 1.909390988239597E-23, 9.546954941197984E-24, 4.773477470598992E-24, 2.386738735299496E-24, 1.193369367649748E-24, 5.96684683824874E-25, 2.98342341912437E-25, 1.491711709562185E-25, 7.458558547810925E-26, 3.7292792739054626E-26, 1.8646396369527313E-26, 9.323198184763657E-27, 4.661599092381828E-27, 2.330799546190914E-27, 1.165399773095457E-27, 5.826998865477285E-28, 2.9134994327386427E-28, 1.4567497163693213E-28, 7.283748581846607E-29, 3.6418742909233034E-29, 1.8209371454616517E-29, 9.104685727308258E-30, 4.552342863654129E-30, 2.2761714318270646E-30};
        double x2 = 1.0;
        double y2 = 0.0;
        double s2 = 1.0;
        for (int k2 = 0; k2 < 53; ++k2) {
            double d2;
            double z2 = x2 + x2 * s2;
            if (d2 <= arg) {
                x2 = z2;
                y2 += ae2[k2];
            }
            s2 *= 0.5;
        }
        return y2;
    }

    public static boolean isIncreasing(int[] a2) {
        for (int i2 = 1; i2 < a2.length; ++i2) {
            if (a2[i2 - 1] < a2[i2]) continue;
            System.out.println("a[" + (i2 - 1) + "] = " + a2[i2 - 1] + " >= " + a2[i2] + " = a[" + i2 + "]");
            return false;
        }
        return true;
    }

    public static byte[] integerToOctets(BigInteger val) {
        byte[] valBytes = val.abs().toByteArray();
        if ((val.bitLength() & 7) != 0) {
            return valBytes;
        }
        byte[] tmp = new byte[val.bitLength() >> 3];
        System.arraycopy(valBytes, 1, tmp, 0, tmp.length);
        return tmp;
    }

    public static BigInteger octetsToInteger(byte[] data, int offset, int length) {
        byte[] byArray = new byte[length + 1];
        byte[] val = byArray;
        byArray[0] = 0;
        System.arraycopy(data, offset, val, 1, length);
        return new BigInteger(val);
    }

    public static BigInteger octetsToInteger(byte[] data) {
        return IntegerFunctions.octetsToInteger(data, 0, data.length);
    }

    public static void main(String[] args) {
        System.out.println("test");
        System.out.println(IntegerFunctions.floatLog(10.0f));
        System.out.println("test2");
    }
}

