/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.util.Selector;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;

public class X509CertStoreSelector
extends X509CertSelector
implements Selector {
    @Override
    public boolean match(Object obj) {
        if (!(obj instanceof X509Certificate)) {
            return false;
        }
        X509Certificate other = (X509Certificate)obj;
        return super.match(other);
    }

    @Override
    public boolean match(Certificate cert) {
        return this.match((Object)cert);
    }

    @Override
    public Object clone() {
        X509CertStoreSelector selector = (X509CertStoreSelector)super.clone();
        return selector;
    }

    public static X509CertStoreSelector getInstance(X509CertSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("cannot create from null selector");
        }
        X509CertStoreSelector cs2 = new X509CertStoreSelector();
        cs2.setAuthorityKeyIdentifier(selector.getAuthorityKeyIdentifier());
        cs2.setBasicConstraints(selector.getBasicConstraints());
        cs2.setCertificate(selector.getCertificate());
        cs2.setCertificateValid(selector.getCertificateValid());
        cs2.setMatchAllSubjectAltNames(selector.getMatchAllSubjectAltNames());
        try {
            cs2.setPathToNames(selector.getPathToNames());
            cs2.setExtendedKeyUsage(selector.getExtendedKeyUsage());
            cs2.setNameConstraints(selector.getNameConstraints());
            cs2.setPolicy(selector.getPolicy());
            cs2.setSubjectPublicKeyAlgID(selector.getSubjectPublicKeyAlgID());
            cs2.setSubjectAlternativeNames(selector.getSubjectAlternativeNames());
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("error in passed in selector: " + e2);
        }
        cs2.setIssuer(selector.getIssuer());
        cs2.setKeyUsage(selector.getKeyUsage());
        cs2.setPrivateKeyValid(selector.getPrivateKeyValid());
        cs2.setSerialNumber(selector.getSerialNumber());
        cs2.setSubject(selector.getSubject());
        cs2.setSubjectKeyIdentifier(selector.getSubjectKeyIdentifier());
        cs2.setSubjectPublicKey(selector.getSubjectPublicKey());
        return cs2;
    }
}

