/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece;

import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class McElieceCCA2PrivateKeyParameters
extends McElieceCCA2KeyParameters {
    private String oid;
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private Permutation p;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;

    public McElieceCCA2PrivateKeyParameters(String oid, int n2, int k2, GF2mField field, PolynomialGF2mSmallM gp, Permutation p2, GF2Matrix h2, PolynomialGF2mSmallM[] qInv, McElieceCCA2Parameters params) {
        super(true, params);
        this.oid = oid;
        this.n = n2;
        this.k = k2;
        this.field = field;
        this.goppaPoly = gp;
        this.p = p2;
        this.h = h2;
        this.qInv = qInv;
    }

    public McElieceCCA2PrivateKeyParameters(String oid, int n2, int k2, byte[] encFieldPoly, byte[] encGoppaPoly, byte[] encP, byte[] encH, byte[][] encQInv, McElieceCCA2Parameters params) {
        super(true, params);
        this.oid = oid;
        this.n = n2;
        this.k = k2;
        this.field = new GF2mField(encFieldPoly);
        this.goppaPoly = new PolynomialGF2mSmallM(this.field, encGoppaPoly);
        this.p = new Permutation(encP);
        this.h = new GF2Matrix(encH);
        this.qInv = new PolynomialGF2mSmallM[encQInv.length];
        for (int i2 = 0; i2 < encQInv.length; ++i2) {
            this.qInv[i2] = new PolynomialGF2mSmallM(this.field, encQInv[i2]);
        }
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public int getT() {
        return this.goppaPoly.getDegree();
    }

    public GF2mField getField() {
        return this.field;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public Permutation getP() {
        return this.p;
    }

    public GF2Matrix getH() {
        return this.h;
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.qInv;
    }

    public String getOIDString() {
        return this.oid;
    }
}

