/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.elgamal;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.oiw.ElGamalParameter;
import com.timevale.tgtext.bouncycastle.jce.provider.JDKAlgorithmParameters;
import com.timevale.tgtext.bouncycastle.jce.spec.ElGamalParameterSpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public class AlgorithmParametersSpi
extends JDKAlgorithmParameters {
    ElGamalParameterSpec currentSpec;

    @Override
    protected byte[] engineGetEncoded() {
        ElGamalParameter elP = new ElGamalParameter(this.currentSpec.getP(), this.currentSpec.getG());
        try {
            return elP.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding ElGamalParameters");
        }
    }

    @Override
    protected byte[] engineGetEncoded(String format) {
        if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
            return this.engineGetEncoded();
        }
        return null;
    }

    @Override
    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == ElGamalParameterSpec.class) {
            return this.currentSpec;
        }
        if (paramSpec == DHParameterSpec.class) {
            return new DHParameterSpec(this.currentSpec.getP(), this.currentSpec.getG());
        }
        throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof ElGamalParameterSpec) && !(paramSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("DHParameterSpec required to initialise a ElGamal algorithm parameters object");
        }
        if (paramSpec instanceof ElGamalParameterSpec) {
            this.currentSpec = (ElGamalParameterSpec)paramSpec;
            return;
        }
        DHParameterSpec s2 = (DHParameterSpec)paramSpec;
        this.currentSpec = new ElGamalParameterSpec(s2.getP(), s2.getG());
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            ElGamalParameter elP = new ElGamalParameter((ASN1Sequence)ASN1Primitive.fromByteArray(params));
            this.currentSpec = new ElGamalParameterSpec(elP.getP(), elP.getG());
            return;
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a valid ElGamal Parameter encoding.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Not a valid ElGamal Parameter encoding.");
        }
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
            this.engineInit(params);
            return;
        }
        throw new IOException("Unknown parameter format " + format);
    }

    @Override
    protected String engineToString() {
        return "ElGamal Parameters";
    }
}

