/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.impl.convertor;

import com.timevale.esign.sdk.tech.bean.AccountBean;
import com.timevale.esign.sdk.tech.bean.CertBean;
import com.timevale.esign.sdk.tech.bean.OrganizeBean;
import com.timevale.esign.sdk.tech.bean.PersonBean;
import com.timevale.esign.sdk.tech.bean.SignBean;
import com.timevale.esign.sdk.tech.bean.SignatureBean;
import com.timevale.esign.sdk.tech.bean.UpdateAccountBean;
import com.timevale.esign.sdk.tech.bean.UpdateOrganizeBean;
import com.timevale.esign.sdk.tech.bean.UpdatePersonBean;
import com.timevale.esign.sdk.tech.bean.result.VerifyPdfResult;
import com.timevale.esign.sdk.tech.impl.model.AccountModel;
import com.timevale.esign.sdk.tech.impl.model.AccountUpdateModel;
import com.timevale.tgpdfsign.sign.f;
import com.timevale.tgpdfsign.sign.h;
import esign.util.constant.c;
import esign.utils.exception.ag;
import esign.utils.exception.aj;
import esign.utils.security.provider.SecurityProvider;
import esign.utils.security.verify.a;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Convertor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Convertor.class);

    public static CertBean convert(a verify) {
        List signers = verify.a();
        if (signers == null || signers.isEmpty()) {
            LOGGER.error("verify result has no signer.");
            return null;
        }
        a.a signer = (a.a)signers.get(0);
        esign.utils.security.a cert = new esign.utils.security.a(signer.a(), SecurityProvider.Default);
        CertBean r = new CertBean();
        r.setCn(cert.f().a());
        r.setSn(cert.a());
        r.setIssuerCN(cert.e().a());
        r.setStartDate(cert.c().toString());
        r.setEndDate(cert.d().toString());
        return r;
    }

    public static AccountModel.Account convert(PersonBean person) {
        AccountModel.Account acc = Convertor.convertAccount(person);
        AccountModel.Person psn = new AccountModel.Person();
        if (StringUtils.isNotBlank((String)person.getCountry()) && StringUtils.isNotBlank((String)person.getProvince()) && StringUtils.isNotBlank((String)person.getCity())) {
            psn.setAddress(person.getCountry() + "#" + person.getProvince() + "#" + person.getCity() + "#" + person.getAddress());
        } else {
            psn.setAddress(person.getAddress());
        }
        psn.setIdNo(person.getIdNo());
        psn.setName(person.getName());
        psn.setOrgan(person.getOrgan());
        if (StringUtils.isNotBlank((String)person.getDepartment())) {
            psn.setTitle(person.getDepartment() + "#" + person.getTitle());
        } else {
            psn.setTitle(person.getTitle());
        }
        psn.setPersonArea(person.getPersonArea());
        acc.setPerson(psn);
        return acc;
    }

    public static AccountUpdateModel.UpdateAccount convert(UpdatePersonBean person) {
        AccountUpdateModel.UpdateAccount acc = Convertor.convertUpdateAccount(person);
        AccountUpdateModel.UpdatePerson psn = new AccountUpdateModel.UpdatePerson();
        psn.setAddress(person.getAddress());
        psn.setOrgan(person.getOrgan());
        psn.setTitle(person.getTitle());
        psn.setName(person.getName());
        acc.setPerson(psn);
        return acc;
    }

    public static AccountModel.Account convert(OrganizeBean organ) {
        AccountModel.Account acc = Convertor.convertAccount(organ);
        AccountModel.Organize org = new AccountModel.Organize();
        org.setName(organ.getName());
        org.setAddress(organ.getAddress());
        org.setAgentIdNo(organ.getAgentIdNo());
        org.setAgentName(organ.getAgentName());
        org.setLegalArea(organ.getLegalArea());
        org.setLegalIdNo(organ.getLegalIdNo());
        org.setLegalName(organ.getLegalName());
        org.setOrganCode(organ.getOrganCode());
        org.setOrganType(organ.getOrganType());
        org.setScope(organ.getScope());
        org.setUserType(organ.getUserType());
        org.setLicenseType(organ.getRegType().val());
        acc.setOrgan(org);
        return acc;
    }

    public static AccountUpdateModel.UpdateAccount convert(UpdateOrganizeBean organ) {
        AccountUpdateModel.UpdateAccount acc = Convertor.convertUpdateAccount(organ);
        AccountUpdateModel.UpdateOrganize org = new AccountUpdateModel.UpdateOrganize();
        org.setName(organ.getName());
        org.setAddress(organ.getAddress());
        org.setAgentIdNo(organ.getAgentIdNo());
        org.setAgentName(organ.getAgentName());
        if (null != organ.getLegalArea()) {
            org.setLegalArea(organ.getLegalArea().type());
        }
        org.setLegalIdNo(organ.getLegalIdNo());
        org.setLegalName(organ.getLegalName());
        if (null != organ.getOrganType()) {
            org.setOrganType(organ.getOrganType().type());
        }
        org.setScope(organ.getScope());
        if (null != organ.getUserType()) {
            org.setUserType(organ.getUserType().type());
        }
        acc.setOrganize(org);
        return acc;
    }

    public static VerifyPdfResult convert(List<f> input) {
        if (input == null || input.isEmpty()) {
            return (VerifyPdfResult)esign.utils.bean.c.a((esign.utils.exception.collector.meta.a)ag.bZ_, VerifyPdfResult.class);
        }
        ArrayList<SignBean> out = new ArrayList<SignBean>();
        for (f s2 : input) {
            SignBean sr = Convertor.convert(s2);
            out.add(sr);
        }
        VerifyPdfResult r = new VerifyPdfResult();
        r.setSignatures(out);
        return r;
    }

    private static SignBean convert(f input) {
        SignBean output = new SignBean();
        output.setSealData(input.d());
        output.setSealName(input.c());
        output.setCert(Convertor.convert(input.b()));
        output.setSignature(Convertor.convert(input.a()));
        return output;
    }

    private static CertBean convert(com.timevale.tgpdfsign.sign.a input) {
        CertBean output = new CertBean();
        output.setCn(input.a());
        output.setSn(input.b());
        output.setIssuerCN(input.c());
        output.setStartDate(input.d());
        output.setEndDate(input.e());
        return output;
    }

    private static SignatureBean convert(h input) {
        SignatureBean output = new SignatureBean();
        output.setSignatureName(input.c());
        output.setValidate(1 == input.d());
        output.setTimeFrom(input.a());
        output.setSignDate(input.e());
        return output;
    }

    private static AccountUpdateModel.UpdateAccount convertUpdateAccount(UpdateAccountBean input) {
        AccountUpdateModel.UpdateAccount acc = new AccountUpdateModel.UpdateAccount();
        acc.setEmail(input.getEmail());
        acc.setMobile(input.getMobile());
        return acc;
    }

    private static AccountModel.Account convertAccount(AccountBean input) {
        AccountModel.Account acc = new AccountModel.Account();
        acc.setEmail(input.getEmail());
        acc.setMobile(input.getMobile());
        return acc;
    }

    public static aj convertException(int code) {
        return Convertor.convertException(code, c.a((int)code));
    }

    public static aj convertException(int code, String msg) {
        return new aj().a(code).a(msg);
    }
}

