/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.eac;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ParsingException;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateBody;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateHolderReference;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.timevale.tgtext.bouncycastle.asn1.eac.Flags;
import com.timevale.tgtext.bouncycastle.asn1.eac.PackedDate;
import java.io.IOException;

public class CVCertificate
extends ASN1Object {
    private CertificateBody certificateBody;
    private byte[] signature;
    private int valid;
    private static int bodyValid = 1;
    private static int signValid = 2;
    public static final byte version_1 = 0;
    public static String ReferenceEncoding = "ISO-8859-1";

    private void setPrivateData(DERApplicationSpecific appSpe) throws IOException {
        this.valid = 0;
        if (appSpe.getApplicationTag() == 33) {
            ASN1Primitive tmpObj;
            ASN1InputStream content = new ASN1InputStream(appSpe.getContents());
            block4: while ((tmpObj = content.readObject()) != null) {
                if (tmpObj instanceof DERApplicationSpecific) {
                    DERApplicationSpecific aSpe = (DERApplicationSpecific)tmpObj;
                    switch (aSpe.getApplicationTag()) {
                        case 78: {
                            this.certificateBody = CertificateBody.getInstance(aSpe);
                            this.valid |= bodyValid;
                            continue block4;
                        }
                        case 55: {
                            this.signature = aSpe.getContents();
                            this.valid |= signValid;
                            continue block4;
                        }
                    }
                    throw new IOException("Invalid tag, not an Iso7816CertificateStructure :" + aSpe.getApplicationTag());
                }
                throw new IOException("Invalid Object, not an Iso7816CertificateStructure");
            }
            return;
        }
        throw new IOException("not a CARDHOLDER_CERTIFICATE :" + appSpe.getApplicationTag());
    }

    public CVCertificate(ASN1InputStream aIS) throws IOException {
        this.initFrom(aIS);
    }

    private void initFrom(ASN1InputStream aIS) throws IOException {
        ASN1Primitive obj;
        while ((obj = aIS.readObject()) != null) {
            if (obj instanceof DERApplicationSpecific) {
                this.setPrivateData((DERApplicationSpecific)obj);
                continue;
            }
            throw new IOException("Invalid Input Stream for creating an Iso7816CertificateStructure");
        }
    }

    private CVCertificate(DERApplicationSpecific appSpe) throws IOException {
        this.setPrivateData(appSpe);
    }

    public CVCertificate(CertificateBody body, byte[] signature) throws IOException {
        this.certificateBody = body;
        this.signature = signature;
        this.valid |= bodyValid;
        this.valid |= signValid;
    }

    public static CVCertificate getInstance(Object obj) {
        if (obj instanceof CVCertificate) {
            return (CVCertificate)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificate(DERApplicationSpecific.getInstance(obj));
            }
            catch (IOException e2) {
                throw new ASN1ParsingException("unable to parse data: " + e2.getMessage(), e2);
            }
        }
        return null;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public CertificateBody getBody() {
        return this.certificateBody;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.valid != (signValid | bodyValid)) {
            return null;
        }
        v2.add(this.certificateBody);
        try {
            v2.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.signature)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to convert signature!");
        }
        return new DERApplicationSpecific(33, v2);
    }

    public ASN1ObjectIdentifier getHolderAuthorization() throws IOException {
        CertificateHolderAuthorization cha = this.certificateBody.getCertificateHolderAuthorization();
        return cha.getOid();
    }

    public PackedDate getEffectiveDate() throws IOException {
        return this.certificateBody.getCertificateEffectiveDate();
    }

    public int getCertificateType() {
        return this.certificateBody.getCertificateType();
    }

    public PackedDate getExpirationDate() throws IOException {
        return this.certificateBody.getCertificateExpirationDate();
    }

    public int getRole() throws IOException {
        CertificateHolderAuthorization cha = this.certificateBody.getCertificateHolderAuthorization();
        return cha.getAccessRights();
    }

    public CertificationAuthorityReference getAuthorityReference() throws IOException {
        return this.certificateBody.getCertificationAuthorityReference();
    }

    public CertificateHolderReference getHolderReference() throws IOException {
        return this.certificateBody.getCertificateHolderReference();
    }

    public int getHolderAuthorizationRole() throws IOException {
        int rights = this.certificateBody.getCertificateHolderAuthorization().getAccessRights();
        return rights & 0xC0;
    }

    public Flags getHolderAuthorizationRights() throws IOException {
        return new Flags(this.certificateBody.getCertificateHolderAuthorization().getAccessRights() & 0x1F);
    }
}

