/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.eac;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.eac.BidirectionalMap;
import com.timevale.tgtext.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.eac.EACTags;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.IOException;
import java.util.Hashtable;

public class CertificateHolderAuthorization
extends ASN1Object {
    ASN1ObjectIdentifier oid;
    DERApplicationSpecific accessRights;
    public static final ASN1ObjectIdentifier id_role_EAC = EACObjectIdentifiers.bsi_de.branch("3.1.2.1");
    public static final int CVCA = 192;
    public static final int DV_DOMESTIC = 128;
    public static final int DV_FOREIGN = 64;
    public static final int IS = 0;
    public static final int RADG4 = 2;
    public static final int RADG3 = 1;
    static Hashtable RightsDecodeMap = new Hashtable();
    static BidirectionalMap AuthorizationRole = new BidirectionalMap();
    static Hashtable ReverseMap = new Hashtable();

    public static String GetRoleDescription(int i2) {
        return (String)AuthorizationRole.get(Integers.valueOf(i2));
    }

    public static int GetFlag(String description) {
        Integer i2 = (Integer)AuthorizationRole.getReverse(description);
        if (i2 == null) {
            throw new IllegalArgumentException("Unknown value " + description);
        }
        return i2;
    }

    private void setPrivateData(ASN1InputStream cha) throws IOException {
        ASN1Primitive obj = cha.readObject();
        if (!(obj instanceof ASN1ObjectIdentifier)) {
            throw new IllegalArgumentException("no Oid in CerticateHolderAuthorization");
        }
        this.oid = (ASN1ObjectIdentifier)obj;
        obj = cha.readObject();
        if (obj instanceof DERApplicationSpecific) {
            this.accessRights = (DERApplicationSpecific)obj;
            return;
        }
        throw new IllegalArgumentException("No access rights in CerticateHolderAuthorization");
    }

    public CertificateHolderAuthorization(ASN1ObjectIdentifier oid, int rights) throws IOException {
        this.setOid(oid);
        this.setAccessRights((byte)rights);
    }

    public CertificateHolderAuthorization(DERApplicationSpecific aSpe) throws IOException {
        if (aSpe.getApplicationTag() == 76) {
            this.setPrivateData(new ASN1InputStream(aSpe.getContents()));
        }
    }

    public int getAccessRights() {
        return this.accessRights.getContents()[0] & 0xFF;
    }

    private void setAccessRights(byte rights) {
        byte[] byArray = new byte[1];
        byte[] accessRights = byArray;
        byArray[0] = rights;
        this.accessRights = new DERApplicationSpecific(EACTags.getTag(83), accessRights);
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    private void setOid(ASN1ObjectIdentifier oid) {
        this.oid = oid;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.oid);
        v2.add(this.accessRights);
        return new DERApplicationSpecific(76, v2);
    }

    static {
        RightsDecodeMap.put(Integers.valueOf(2), "RADG4");
        RightsDecodeMap.put(Integers.valueOf(1), "RADG3");
        AuthorizationRole.put(Integers.valueOf(192), "CVCA");
        AuthorizationRole.put(Integers.valueOf(128), "DV_DOMESTIC");
        AuthorizationRole.put(Integers.valueOf(64), "DV_FOREIGN");
        AuthorizationRole.put(Integers.valueOf(0), "IS");
    }
}

