/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.PasswordRecipientInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSPBEKey;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import com.timevale.tgtext.bouncycastle.cms.PKCS5Scheme2UTF8PBEKey;
import com.timevale.tgtext.bouncycastle.cms.PasswordRecipient;
import com.timevale.tgtext.bouncycastle.cms.PasswordRecipientId;
import com.timevale.tgtext.bouncycastle.cms.Recipient;
import com.timevale.tgtext.bouncycastle.cms.RecipientInformation;
import com.timevale.tgtext.bouncycastle.cms.RecipientOperator;
import com.timevale.tgtext.bouncycastle.cms.a;
import com.timevale.tgtext.bouncycastle.cms.d;
import com.timevale.tgtext.bouncycastle.cms.g;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceAlgorithmIdentifierConverter;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcePasswordAuthenticatedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcePasswordEnvelopedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcePasswordRecipient;
import com.timevale.tgtext.bouncycastle.crypto.PBEParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;

public class PasswordRecipientInformation
extends RecipientInformation {
    static Map KEYSIZES = new HashMap();
    static Map BLOCKSIZES = new HashMap<ASN1ObjectIdentifier, Integer>();
    private PasswordRecipientInfo info;

    PasswordRecipientInformation(PasswordRecipientInfo info, AlgorithmIdentifier messageAlgorithm, g secureReadable, a additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = new PasswordRecipientId();
    }

    public String getKeyDerivationAlgOID() {
        if (this.info.getKeyDerivationAlgorithm() != null) {
            return this.info.getKeyDerivationAlgorithm().getAlgorithm().getId();
        }
        return null;
    }

    public byte[] getKeyDerivationAlgParams() {
        try {
            ASN1Encodable params;
            if (this.info.getKeyDerivationAlgorithm() != null && (params = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                return params.toASN1Primitive().getEncoded();
            }
            return null;
        }
        catch (Exception e2) {
            throw new RuntimeException("exception getting encryption parameters " + e2);
        }
    }

    public AlgorithmIdentifier getKeyDerivationAlgorithm() {
        return this.info.getKeyDerivationAlgorithm();
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(String provider) throws NoSuchProviderException {
        return this.getKeyDerivationAlgParameters(i.a(provider));
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(Provider provider) {
        try {
            return new JceAlgorithmIdentifierConverter().setProvider(provider).getAlgorithmParameters(this.info.getKeyDerivationAlgorithm());
        }
        catch (Exception e2) {
            throw new RuntimeException("exception getting encryption parameters " + e2);
        }
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, i.a(prov));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            CMSPBEKey pbeKey = (CMSPBEKey)key;
            JcePasswordRecipient recipient = this.secureReadable instanceof d.c ? new JcePasswordEnvelopedRecipient(pbeKey.getPassword()) : new JcePasswordAuthenticatedRecipient(pbeKey.getPassword());
            recipient.setPasswordConversionScheme(pbeKey instanceof PKCS5Scheme2UTF8PBEKey ? 1 : 0);
            if (prov != null) {
                recipient.setProvider(prov);
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e2) {
            throw new CMSException("encoding error: " + e2.getMessage(), e2);
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        PasswordRecipient pbeRecipient = (PasswordRecipient)recipient;
        AlgorithmIdentifier kekAlg = AlgorithmIdentifier.getInstance(this.info.getKeyEncryptionAlgorithm());
        AlgorithmIdentifier kekAlgParams = AlgorithmIdentifier.getInstance(kekAlg.getParameters());
        byte[] passwordBytes = this.getPasswordBytes(pbeRecipient.getPasswordConversionScheme(), pbeRecipient.getPassword());
        PBKDF2Params params = PBKDF2Params.getInstance(this.info.getKeyDerivationAlgorithm().getParameters());
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        gen.init(passwordBytes, params.getSalt(), params.getIterationCount().intValue());
        int keySize = (Integer)KEYSIZES.get(kekAlgParams.getAlgorithm());
        byte[] derivedKey = ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
        return pbeRecipient.getRecipientOperator(kekAlgParams, this.messageAlgorithm, derivedKey, this.info.getEncryptedKey().getOctets());
    }

    protected byte[] getPasswordBytes(int scheme, char[] password) {
        if (scheme == 0) {
            return PBEParametersGenerator.PKCS5PasswordToBytes(password);
        }
        return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(password);
    }

    static {
        BLOCKSIZES.put(CMSAlgorithm.DES_EDE3_CBC, Integers.valueOf(8));
        BLOCKSIZES.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(16));
        BLOCKSIZES.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(16));
        BLOCKSIZES.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(16));
        KEYSIZES.put(CMSAlgorithm.DES_EDE3_CBC, Integers.valueOf(192));
        KEYSIZES.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(128));
        KEYSIZES.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(192));
        KEYSIZES.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(256));
    }
}

