/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.Layer;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import java.security.SecureRandom;

public class RainbowKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private boolean initialized = false;
    private SecureRandom sr;
    private RainbowKeyGenerationParameters rainbowParams;
    private short[][] A1;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2;
    private short[][] A2inv;
    private short[] b2;
    private int numOfLayers;
    private Layer[] layers;
    private int[] vi;
    private short[][] pub_quadratic;
    private short[][] pub_singular;
    private short[] pub_scalar;

    public AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        this.keygen();
        RainbowPrivateKeyParameters privKey = new RainbowPrivateKeyParameters(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        RainbowPublicKeyParameters pubKey = new RainbowPublicKeyParameters(this.vi[this.vi.length - 1] - this.vi[0], this.pub_quadratic, this.pub_singular, this.pub_scalar);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public void initialize(KeyGenerationParameters param) {
        this.rainbowParams = (RainbowKeyGenerationParameters)param;
        this.sr = new SecureRandom();
        this.vi = this.rainbowParams.getParameters().getVi();
        this.numOfLayers = this.rainbowParams.getParameters().getNumOfLayers();
        this.initialized = true;
    }

    private void initializeDefault() {
        RainbowKeyGenerationParameters rbKGParams = new RainbowKeyGenerationParameters(new SecureRandom(), new RainbowParameters());
        this.initialize(rbKGParams);
    }

    private void keygen() {
        this.generateL1();
        this.generateL2();
        this.generateF();
        this.computePublicKey();
    }

    private void generateL1() {
        int i2;
        int dim = this.vi[this.vi.length - 1] - this.vi[0];
        this.A1 = new short[dim][dim];
        this.A1inv = null;
        ComputeInField c2 = new ComputeInField();
        while (this.A1inv == null) {
            for (i2 = 0; i2 < dim; ++i2) {
                for (int j2 = 0; j2 < dim; ++j2) {
                    this.A1[i2][j2] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A1inv = c2.inverse(this.A1);
        }
        this.b1 = new short[dim];
        for (i2 = 0; i2 < dim; ++i2) {
            this.b1[i2] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateL2() {
        int i2;
        int dim = this.vi[this.vi.length - 1];
        this.A2 = new short[dim][dim];
        this.A2inv = null;
        ComputeInField c2 = new ComputeInField();
        while (this.A2inv == null) {
            for (i2 = 0; i2 < dim; ++i2) {
                for (int j2 = 0; j2 < dim; ++j2) {
                    this.A2[i2][j2] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A2inv = c2.inverse(this.A2);
        }
        this.b2 = new short[dim];
        for (i2 = 0; i2 < dim; ++i2) {
            this.b2[i2] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateF() {
        this.layers = new Layer[this.numOfLayers];
        for (int i2 = 0; i2 < this.numOfLayers; ++i2) {
            this.layers[i2] = new Layer(this.vi[i2], this.vi[i2 + 1], this.sr);
        }
    }

    private void computePublicKey() {
        ComputeInField c2 = new ComputeInField();
        int rows = this.vi[this.vi.length - 1] - this.vi[0];
        int vars = this.vi[this.vi.length - 1];
        short[][][] coeff_quadratic_3dim = new short[rows][vars][vars];
        this.pub_singular = new short[rows][vars];
        this.pub_scalar = new short[rows];
        int crnt_row = 0;
        for (int l2 = 0; l2 < this.layers.length; ++l2) {
            short[][][] coeff_alpha = this.layers[l2].getCoeffAlpha();
            short[][][] coeff_beta = this.layers[l2].getCoeffBeta();
            short[][] coeff_gamma = this.layers[l2].getCoeffGamma();
            short[] coeff_eta = this.layers[l2].getCoeffEta();
            int oils = coeff_alpha[0].length;
            int vins = coeff_beta[0].length;
            for (int p2 = 0; p2 < oils; ++p2) {
                short sclr_tmp;
                short[] vect_tmp;
                int x2;
                int x1;
                for (x1 = 0; x1 < oils; ++x1) {
                    for (x2 = 0; x2 < vins; ++x2) {
                        vect_tmp = c2.multVect(coeff_alpha[p2][x1][x2], this.A2[x1 + vins]);
                        coeff_quadratic_3dim[crnt_row + p2] = c2.addSquareMatrix(coeff_quadratic_3dim[crnt_row + p2], c2.multVects(vect_tmp, this.A2[x2]));
                        vect_tmp = c2.multVect(this.b2[x2], vect_tmp);
                        this.pub_singular[crnt_row + p2] = c2.addVect(vect_tmp, this.pub_singular[crnt_row + p2]);
                        vect_tmp = c2.multVect(coeff_alpha[p2][x1][x2], this.A2[x2]);
                        vect_tmp = c2.multVect(this.b2[x1 + vins], vect_tmp);
                        this.pub_singular[crnt_row + p2] = c2.addVect(vect_tmp, this.pub_singular[crnt_row + p2]);
                        sclr_tmp = GF2Field.multElem(coeff_alpha[p2][x1][x2], this.b2[x1 + vins]);
                        this.pub_scalar[crnt_row + p2] = GF2Field.addElem(this.pub_scalar[crnt_row + p2], GF2Field.multElem(sclr_tmp, this.b2[x2]));
                    }
                }
                for (x1 = 0; x1 < vins; ++x1) {
                    for (x2 = 0; x2 < vins; ++x2) {
                        vect_tmp = c2.multVect(coeff_beta[p2][x1][x2], this.A2[x1]);
                        coeff_quadratic_3dim[crnt_row + p2] = c2.addSquareMatrix(coeff_quadratic_3dim[crnt_row + p2], c2.multVects(vect_tmp, this.A2[x2]));
                        vect_tmp = c2.multVect(this.b2[x2], vect_tmp);
                        this.pub_singular[crnt_row + p2] = c2.addVect(vect_tmp, this.pub_singular[crnt_row + p2]);
                        vect_tmp = c2.multVect(coeff_beta[p2][x1][x2], this.A2[x2]);
                        vect_tmp = c2.multVect(this.b2[x1], vect_tmp);
                        this.pub_singular[crnt_row + p2] = c2.addVect(vect_tmp, this.pub_singular[crnt_row + p2]);
                        sclr_tmp = GF2Field.multElem(coeff_beta[p2][x1][x2], this.b2[x1]);
                        this.pub_scalar[crnt_row + p2] = GF2Field.addElem(this.pub_scalar[crnt_row + p2], GF2Field.multElem(sclr_tmp, this.b2[x2]));
                    }
                }
                for (int n2 = 0; n2 < vins + oils; ++n2) {
                    vect_tmp = c2.multVect(coeff_gamma[p2][n2], this.A2[n2]);
                    this.pub_singular[crnt_row + p2] = c2.addVect(vect_tmp, this.pub_singular[crnt_row + p2]);
                    this.pub_scalar[crnt_row + p2] = GF2Field.addElem(this.pub_scalar[crnt_row + p2], GF2Field.multElem(coeff_gamma[p2][n2], this.b2[n2]));
                }
                this.pub_scalar[crnt_row + p2] = GF2Field.addElem(this.pub_scalar[crnt_row + p2], coeff_eta[p2]);
            }
            crnt_row += oils;
        }
        short[][][] tmp_c_quad = new short[rows][vars][vars];
        short[][] tmp_c_sing = new short[rows][vars];
        short[] tmp_c_scal = new short[rows];
        for (int r2 = 0; r2 < rows; ++r2) {
            for (int q2 = 0; q2 < this.A1.length; ++q2) {
                tmp_c_quad[r2] = c2.addSquareMatrix(tmp_c_quad[r2], c2.multMatrix(this.A1[r2][q2], coeff_quadratic_3dim[q2]));
                tmp_c_sing[r2] = c2.addVect(tmp_c_sing[r2], c2.multVect(this.A1[r2][q2], this.pub_singular[q2]));
                tmp_c_scal[r2] = GF2Field.addElem(tmp_c_scal[r2], GF2Field.multElem(this.A1[r2][q2], this.pub_scalar[q2]));
            }
            tmp_c_scal[r2] = GF2Field.addElem(tmp_c_scal[r2], this.b1[r2]);
        }
        coeff_quadratic_3dim = tmp_c_quad;
        this.pub_singular = tmp_c_sing;
        this.pub_scalar = tmp_c_scal;
        this.compactPublicKey(coeff_quadratic_3dim);
    }

    private void compactPublicKey(short[][][] coeff_quadratic_to_compact) {
        int polynomials = coeff_quadratic_to_compact.length;
        int n2 = coeff_quadratic_to_compact[0].length;
        int entries = n2 * (n2 + 1) / 2;
        this.pub_quadratic = new short[polynomials][entries];
        for (int p2 = 0; p2 < polynomials; ++p2) {
            int offset = 0;
            for (int x2 = 0; x2 < n2; ++x2) {
                for (int y2 = x2; y2 < n2; ++y2) {
                    this.pub_quadratic[p2][offset] = y2 == x2 ? coeff_quadratic_to_compact[p2][x2][y2] : GF2Field.addElem(coeff_quadratic_to_compact[p2][x2][y2], coeff_quadratic_to_compact[p2][y2][x2]);
                    ++offset;
                }
            }
        }
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

