/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.util.test;

import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.test.SimpleTestResult;
import com.timevale.tgtext.bouncycastle.util.test.Test;
import com.timevale.tgtext.bouncycastle.util.test.TestFailedException;
import com.timevale.tgtext.bouncycastle.util.test.TestResult;
import java.io.PrintStream;

public abstract class SimpleTest
implements Test {
    @Override
    public abstract String getName();

    private TestResult success() {
        return SimpleTestResult.successful(this, "Okay");
    }

    protected void fail(String message) {
        throw new TestFailedException(SimpleTestResult.failed(this, message));
    }

    protected void fail(String message, Throwable throwable) {
        throw new TestFailedException(SimpleTestResult.failed(this, message, throwable));
    }

    protected void fail(String message, Object expected, Object found) {
        throw new TestFailedException(SimpleTestResult.failed(this, message, expected, found));
    }

    protected boolean areEqual(byte[] a2, byte[] b2) {
        return Arrays.areEqual(a2, b2);
    }

    @Override
    public TestResult perform() {
        try {
            this.performTest();
            return this.success();
        }
        catch (TestFailedException testFailedException) {
            TestFailedException e2 = testFailedException;
            return testFailedException.getResult();
        }
        catch (Exception e3) {
            return SimpleTestResult.failed(this, "Exception: " + e3, e3);
        }
    }

    protected static void runTest(Test test) {
        SimpleTest.runTest(test, System.out);
    }

    protected static void runTest(Test test, PrintStream out) {
        TestResult result = test.perform();
        out.println(result.toString());
        if (result.getException() != null) {
            result.getException().printStackTrace(out);
        }
    }

    public abstract void performTest() throws Exception;
}

