/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.digest;

import com.timevale.tgtext.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.CipherKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.timevale.tgtext.bouncycastle.crypto.macs.HMac;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.a;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.timevale.tgtext.bouncycastle.jce.provider.JCEMac;

public class RIPEMD160 {

    public static class Mappings
    extends a {
        private static final String PREFIX = RIPEMD160.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.RIPEMD160", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
            this.addHMACAlgorithm(provider, "RIPEMD160", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "RIPEMD160", IANAObjectIdentifiers.hmacRIPEMD160);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD160", 160, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new RIPEMD160Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD160Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d2 = (Digest)super.clone();
            ((Digest)super.clone()).digest = new RIPEMD160Digest((RIPEMD160Digest)this.digest);
            return d2;
        }
    }
}

