/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.util.encoders;

import com.timevale.tgtext.bouncycastle.util.encoders.Base64Encoder;
import com.timevale.tgtext.bouncycastle.util.encoders.DecoderException;
import com.timevale.tgtext.bouncycastle.util.encoders.Encoder;
import com.timevale.tgtext.bouncycastle.util.encoders.EncoderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64 {
    private static final Encoder encoder = new Base64Encoder();

    public static byte[] encode(byte[] data) {
        int len = (data.length + 2) / 3 << 2;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            encoder.encode(data, 0, data.length, bOut);
        }
        catch (Exception e2) {
            throw new EncoderException("exception encoding base64 string: " + e2.getMessage(), e2);
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return encoder.encode(data, 0, data.length, out);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        return encoder.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        int len = data.length / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            encoder.decode(data, 0, data.length, bOut);
        }
        catch (Exception e2) {
            throw new DecoderException("unable to decode base64 data: " + e2.getMessage(), e2);
        }
        return bOut.toByteArray();
    }

    public static byte[] decode(String data) {
        int len = data.length() / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            encoder.decode(data, bOut);
        }
        catch (Exception e2) {
            throw new DecoderException("unable to decode base64 string: " + e2.getMessage(), e2);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return encoder.decode(data, out);
    }
}

