/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERGeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import java.util.Enumeration;

public class PrivateKeyUsagePeriod
extends ASN1Object {
    private DERGeneralizedTime _notBefore;
    private DERGeneralizedTime _notAfter;

    public static PrivateKeyUsagePeriod getInstance(Object obj) {
        if (obj instanceof PrivateKeyUsagePeriod) {
            return (PrivateKeyUsagePeriod)obj;
        }
        if (obj != null) {
            return new PrivateKeyUsagePeriod(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PrivateKeyUsagePeriod(ASN1Sequence seq) {
        Enumeration en2 = seq.getObjects();
        while (en2.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en2.nextElement();
            if (tObj.getTagNo() == 0) {
                this._notBefore = DERGeneralizedTime.getInstance(tObj, false);
                continue;
            }
            if (tObj.getTagNo() != 1) continue;
            this._notAfter = DERGeneralizedTime.getInstance(tObj, false);
        }
    }

    public DERGeneralizedTime getNotBefore() {
        return this._notBefore;
    }

    public DERGeneralizedTime getNotAfter() {
        return this._notAfter;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this._notBefore != null) {
            v2.add(new DERTaggedObject(false, 0, this._notBefore));
        }
        if (this._notAfter != null) {
            v2.add(new DERTaggedObject(false, 1, this._notAfter));
        }
        return new DERSequence(v2);
    }
}

