/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBEParameter;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.timevale.tgtext.bouncycastle.asn1.sec.ECPrivateKey;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.PBEParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.jce.ECNamedCurveTable;
import com.timevale.tgtext.bouncycastle.jce.PKCS10CertificationRequest;
import com.timevale.tgtext.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.timevale.tgtext.bouncycastle.openssl.EncryptionException;
import com.timevale.tgtext.bouncycastle.openssl.PEMException;
import com.timevale.tgtext.bouncycastle.openssl.PEMUtilities;
import com.timevale.tgtext.bouncycastle.openssl.PasswordException;
import com.timevale.tgtext.bouncycastle.openssl.PasswordFinder;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemHeader;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObject;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObjectParser;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemReader;
import com.timevale.tgtext.bouncycastle.x509.X509V2AttributeCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PEMReader
extends PemReader {
    private final Map parsers = new HashMap();
    private PasswordFinder pFinder;

    public PEMReader(Reader reader) {
        this(reader, null, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder pFinder) {
        this(reader, pFinder, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder pFinder, String provider) {
        this(reader, pFinder, provider, provider);
    }

    public PEMReader(Reader reader, PasswordFinder pFinder, String symProvider, String asymProvider) {
        super(reader);
        this.pFinder = pFinder;
        this.parsers.put("CERTIFICATE REQUEST", new f());
        this.parsers.put("NEW CERTIFICATE REQUEST", new f());
        this.parsers.put("CERTIFICATE", new n(asymProvider));
        this.parsers.put("X509 CERTIFICATE", new n(asymProvider));
        this.parsers.put("X509 CRL", new m(asymProvider));
        this.parsers.put("PKCS7", new g());
        this.parsers.put("ATTRIBUTE CERTIFICATE", new l());
        this.parsers.put("EC PARAMETERS", new c());
        this.parsers.put("PUBLIC KEY", new i(asymProvider));
        this.parsers.put("RSA PUBLIC KEY", new k(asymProvider));
        this.parsers.put("RSA PRIVATE KEY", new j(symProvider, asymProvider));
        this.parsers.put("DSA PRIVATE KEY", new a(symProvider, asymProvider));
        this.parsers.put("EC PRIVATE KEY", new b(symProvider, asymProvider));
        this.parsers.put("ENCRYPTED PRIVATE KEY", new d(symProvider, asymProvider));
        this.parsers.put("PRIVATE KEY", new h(asymProvider));
    }

    public Object readObject() throws IOException {
        PemObject obj = this.readPemObject();
        if (obj != null) {
            String type = obj.getType();
            if (this.parsers.containsKey(type)) {
                return ((PemObjectParser)this.parsers.get(type)).parseObject(obj);
            }
            throw new IOException("unrecognised object: " + type);
        }
        return null;
    }

    static byte[] crypt(boolean encrypt, String provider, byte[] bytes, char[] password, String dekAlgName, byte[] iv) throws IOException {
        Provider prov = null;
        if (provider != null && (prov = Security.getProvider(provider)) == null) {
            throw new EncryptionException("cannot find provider: " + provider);
        }
        return PEMReader.crypt(encrypt, prov, bytes, password, dekAlgName, iv);
    }

    static byte[] crypt(boolean encrypt, Provider provider, byte[] bytes, char[] password, String dekAlgName, byte[] iv) throws IOException {
        SecretKey sKey;
        String alg;
        AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
        String blockMode = "CBC";
        String padding = "PKCS5Padding";
        if (dekAlgName.endsWith("-CFB")) {
            blockMode = "CFB";
            padding = "NoPadding";
        }
        if (dekAlgName.endsWith("-ECB") || "DES-EDE".equals(dekAlgName) || "DES-EDE3".equals(dekAlgName)) {
            blockMode = "ECB";
            paramSpec = null;
        }
        if (dekAlgName.endsWith("-OFB")) {
            blockMode = "OFB";
            padding = "NoPadding";
        }
        if (dekAlgName.startsWith("DES-EDE")) {
            alg = "DESede";
            boolean des2 = !dekAlgName.startsWith("DES-EDE3");
            sKey = PEMReader.getKey(password, alg, 24, iv, des2);
        } else if (dekAlgName.startsWith("DES-")) {
            alg = "DES";
            sKey = PEMReader.getKey(password, alg, 8, iv);
        } else if (dekAlgName.startsWith("BF-")) {
            alg = "Blowfish";
            sKey = PEMReader.getKey(password, alg, 16, iv);
        } else if (dekAlgName.startsWith("RC2-")) {
            alg = "RC2";
            int keyBits = 128;
            if (dekAlgName.startsWith("RC2-40-")) {
                keyBits = 40;
            } else if (dekAlgName.startsWith("RC2-64-")) {
                keyBits = 64;
            }
            sKey = PEMReader.getKey(password, alg, keyBits / 8, iv);
            paramSpec = paramSpec == null ? new RC2ParameterSpec(keyBits) : new RC2ParameterSpec(keyBits, iv);
        } else if (dekAlgName.startsWith("AES-")) {
            int keyBits;
            alg = "AES";
            byte[] salt = iv;
            if (iv.length > 8) {
                salt = new byte[8];
                System.arraycopy(iv, 0, salt, 0, 8);
            }
            if (dekAlgName.startsWith("AES-128-")) {
                keyBits = 128;
            } else if (dekAlgName.startsWith("AES-192-")) {
                keyBits = 192;
            } else if (dekAlgName.startsWith("AES-256-")) {
                keyBits = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            sKey = PEMReader.getKey(password, "AES", keyBits / 8, salt);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String transformation = alg + "/" + blockMode + "/" + padding;
        try {
            int mode;
            Cipher c2 = Cipher.getInstance(transformation, provider);
            int n2 = mode = encrypt ? 1 : 2;
            if (paramSpec == null) {
                c2.init(mode, sKey);
            } else {
                c2.init(mode, (Key)sKey, paramSpec);
            }
            return c2.doFinal(bytes);
        }
        catch (Exception e2) {
            throw new EncryptionException("exception using cipher - please check password and data.", (Throwable)e2);
        }
    }

    private static SecretKey getKey(char[] password, String algorithm, int keyLength, byte[] salt) {
        return PEMReader.getKey(password, algorithm, keyLength, salt, false);
    }

    private static SecretKey getKey(char[] password, String algorithm, int keyLength, byte[] salt, boolean des2) {
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(password), salt);
        KeyParameter keyParam = (KeyParameter)pGen.generateDerivedParameters(keyLength << 3);
        byte[] key = keyParam.getKey();
        if (des2 && key.length >= 24) {
            System.arraycopy(key, 0, key, 16, 8);
        }
        return new SecretKeySpec(key, algorithm);
    }

    public static SecretKey generateSecretKeyForPKCS5Scheme2(String algorithm, char[] password, byte[] salt, int iterationCount) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        generator.init(PBEParametersGenerator.PKCS5PasswordToBytes(password), salt, iterationCount);
        return new SecretKeySpec(((KeyParameter)((PBEParametersGenerator)generator).generateDerivedParameters(PEMUtilities.getKeySize(algorithm))).getKey(), algorithm);
    }

    private class h
    implements PemObjectParser {
        private String b;

        public h(String provider) {
            this.b = provider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                PrivateKeyInfo info = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(obj.getContent()));
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(obj.getContent());
                KeyFactory keyFact = KeyFactory.getInstance(info.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.b);
                return keyFact.generatePrivate(keySpec);
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing PRIVATE KEY: " + e2.toString(), e2);
            }
        }
    }

    private class d
    implements PemObjectParser {
        private String b;
        private String c;

        public d(String symProvider, String asymProvider) {
            this.b = symProvider;
            this.c = asymProvider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                EncryptedPrivateKeyInfo info = EncryptedPrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(obj.getContent()));
                AlgorithmIdentifier algId = info.getEncryptionAlgorithm();
                if (PEMReader.this.pFinder == null) {
                    throw new PEMException("no PasswordFinder specified");
                }
                if (PEMUtilities.isPKCS5Scheme2(algId.getAlgorithm())) {
                    PBES2Parameters params = PBES2Parameters.getInstance(algId.getParameters());
                    KeyDerivationFunc func = params.getKeyDerivationFunc();
                    EncryptionScheme scheme = params.getEncryptionScheme();
                    PBKDF2Params defParams = (PBKDF2Params)func.getParameters();
                    int iterationCount = defParams.getIterationCount().intValue();
                    byte[] salt = defParams.getSalt();
                    String algorithm = scheme.getAlgorithm().getId();
                    SecretKey key = PEMReader.generateSecretKeyForPKCS5Scheme2(algorithm, PEMReader.this.pFinder.getPassword(), salt, iterationCount);
                    Cipher cipher = Cipher.getInstance(algorithm, this.b);
                    AlgorithmParameters algParams = AlgorithmParameters.getInstance(algorithm, this.b);
                    algParams.init(scheme.getParameters().toASN1Primitive().getEncoded());
                    cipher.init(2, (Key)key, algParams);
                    PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(cipher.doFinal(info.getEncryptedData())));
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pInfo.getEncoded());
                    KeyFactory keyFact = KeyFactory.getInstance(pInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.c);
                    return keyFact.generatePrivate(keySpec);
                }
                if (PEMUtilities.isPKCS12(algId.getAlgorithm())) {
                    PKCS12PBEParams params = PKCS12PBEParams.getInstance(algId.getParameters());
                    String algorithm = algId.getAlgorithm().getId();
                    PBEKeySpec pbeSpec = new PBEKeySpec(PEMReader.this.pFinder.getPassword());
                    SecretKeyFactory secKeyFact = SecretKeyFactory.getInstance(algorithm, this.b);
                    PBEParameterSpec defParams = new PBEParameterSpec(params.getIV(), params.getIterations().intValue());
                    Cipher cipher = Cipher.getInstance(algorithm, this.b);
                    cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(cipher.doFinal(info.getEncryptedData())));
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pInfo.getEncoded());
                    KeyFactory keyFact = KeyFactory.getInstance(pInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.c);
                    return keyFact.generatePrivate(keySpec);
                }
                if (PEMUtilities.isPKCS5Scheme1(algId.getAlgorithm())) {
                    PBEParameter params = PBEParameter.getInstance(algId.getParameters());
                    String algorithm = algId.getAlgorithm().getId();
                    PBEKeySpec pbeSpec = new PBEKeySpec(PEMReader.this.pFinder.getPassword());
                    SecretKeyFactory secKeyFact = SecretKeyFactory.getInstance(algorithm, this.b);
                    PBEParameterSpec defParams = new PBEParameterSpec(params.getSalt(), params.getIterationCount().intValue());
                    Cipher cipher = Cipher.getInstance(algorithm, this.b);
                    cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(cipher.doFinal(info.getEncryptedData())));
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pInfo.getEncoded());
                    KeyFactory keyFact = KeyFactory.getInstance(pInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.c);
                    return keyFact.generatePrivate(keySpec);
                }
                throw new PEMException("Unknown algorithm: " + algId.getAlgorithm());
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem parsing ENCRYPTED PRIVATE KEY: " + e3.toString(), e3);
            }
        }
    }

    private class c
    implements PemObjectParser {
        private c() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                DERObjectIdentifier oid = (DERObjectIdentifier)ASN1Primitive.fromByteArray(obj.getContent());
                ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec(oid.getId());
                if (params == null) {
                    throw new IOException("object ID not found in EC curve table");
                }
                return params;
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("exception extracting EC named curve: " + e3.toString());
            }
        }
    }

    private class l
    implements PemObjectParser {
        private l() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            return new X509V2AttributeCertificate(obj.getContent());
        }
    }

    private class g
    implements PemObjectParser {
        private g() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1InputStream aIn = new ASN1InputStream(obj.getContent());
                return ContentInfo.getInstance(aIn.readObject());
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing PKCS7 object: " + e2.toString(), e2);
            }
        }
    }

    private class f
    implements PemObjectParser {
        private f() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new PKCS10CertificationRequest(obj.getContent());
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing certrequest: " + e2.toString(), e2);
            }
        }
    }

    private class m
    implements PemObjectParser {
        private String b;

        public m(String provider) {
            this.b = provider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            ByteArrayInputStream bIn = new ByteArrayInputStream(obj.getContent());
            try {
                CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.b);
                return certFact.generateCRL(bIn);
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing cert: " + e2.toString(), e2);
            }
        }
    }

    private class n
    implements PemObjectParser {
        private String b;

        public n(String provider) {
            this.b = provider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            ByteArrayInputStream bIn = new ByteArrayInputStream(obj.getContent());
            try {
                CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.b);
                return certFact.generateCertificate(bIn);
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing cert: " + e2.toString(), e2);
            }
        }
    }

    private class k
    implements PemObjectParser {
        private String b;

        public k(String provider) {
            this.b = provider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1InputStream ais = new ASN1InputStream(obj.getContent());
                ASN1Primitive asnObject = ais.readObject();
                ASN1Sequence sequence = (ASN1Sequence)asnObject;
                RSAPublicKey rsaPubStructure = RSAPublicKey.getInstance(sequence);
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPubStructure.getModulus(), rsaPubStructure.getPublicExponent());
                KeyFactory keyFact = KeyFactory.getInstance("RSA", this.b);
                return keyFact.generatePublic(keySpec);
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IOException("can't find provider " + this.b);
            }
            catch (Exception e3) {
                throw new PEMException("problem extracting key: " + e3.toString(), e3);
            }
        }
    }

    private class i
    implements PemObjectParser {
        private String b;

        public i(String provider) {
            this.b = provider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(obj.getContent());
            String[] algorithms = new String[]{"DSA", "RSA"};
            for (int i2 = 0; i2 < 2; ++i2) {
                try {
                    KeyFactory keyFact = KeyFactory.getInstance(algorithms[i2], this.b);
                    PublicKey pubKey = keyFact.generatePublic(keySpec);
                    return pubKey;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    continue;
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    continue;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new RuntimeException("can't find provider " + this.b);
                }
            }
            return null;
        }
    }

    private class j
    extends e {
        private String d;

        public j(String symProvider, String asymProvider) {
            super(symProvider);
            this.d = asymProvider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1Sequence seq = this.a(obj);
                if (seq.size() != 9) {
                    throw new PEMException("malformed sequence in RSA private key");
                }
                RSAPrivateKey keyStruct = RSAPrivateKey.getInstance(seq);
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(keyStruct.getModulus(), keyStruct.getPublicExponent());
                RSAPrivateCrtKeySpec privSpec = new RSAPrivateCrtKeySpec(keyStruct.getModulus(), keyStruct.getPublicExponent(), keyStruct.getPrivateExponent(), keyStruct.getPrime1(), keyStruct.getPrime2(), keyStruct.getExponent1(), keyStruct.getExponent2(), keyStruct.getCoefficient());
                KeyFactory fact = KeyFactory.getInstance("RSA", this.d);
                return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem creating RSA private key: " + e3.toString(), e3);
            }
        }
    }

    private class b
    extends e {
        private String d;

        public b(String symProvider, String asymProvider) {
            super(symProvider);
            this.d = asymProvider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1Sequence seq = this.a(obj);
                ECPrivateKey pKey = ECPrivateKey.getInstance(seq);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)pKey.getParameters());
                PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, pKey);
                SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
                PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privInfo.getEncoded());
                X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
                KeyFactory fact = KeyFactory.getInstance("ECDSA", this.d);
                return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem creating EC private key: " + e3.toString(), e3);
            }
        }
    }

    private class a
    extends e {
        private String d;

        public a(String symProvider, String asymProvider) {
            super(symProvider);
            this.d = asymProvider;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1Sequence seq = this.a(obj);
                if (seq.size() != 6) {
                    throw new PEMException("malformed sequence in DSA private key");
                }
                DERInteger p2 = (DERInteger)seq.getObjectAt(1);
                DERInteger q2 = (DERInteger)seq.getObjectAt(2);
                DERInteger g2 = (DERInteger)seq.getObjectAt(3);
                DERInteger y2 = (DERInteger)seq.getObjectAt(4);
                DERInteger x2 = (DERInteger)seq.getObjectAt(5);
                DSAPrivateKeySpec privSpec = new DSAPrivateKeySpec(x2.getValue(), p2.getValue(), q2.getValue(), g2.getValue());
                DSAPublicKeySpec pubSpec = new DSAPublicKeySpec(y2.getValue(), p2.getValue(), q2.getValue(), g2.getValue());
                KeyFactory fact = KeyFactory.getInstance("DSA", this.d);
                return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem creating DSA private key: " + e3.toString(), e3);
            }
        }
    }

    private abstract class e
    implements PemObjectParser {
        protected String b;

        public e(String symProvider) {
            this.b = symProvider;
        }

        protected ASN1Sequence a(PemObject obj) throws IOException {
            boolean isEncrypted = false;
            String dekInfo = null;
            List headers = obj.getHeaders();
            for (PemHeader hdr : headers) {
                if (hdr.getName().equals("Proc-Type") && hdr.getValue().equals("4,ENCRYPTED")) {
                    isEncrypted = true;
                    continue;
                }
                if (!hdr.getName().equals("DEK-Info")) continue;
                dekInfo = hdr.getValue();
            }
            byte[] keyBytes = obj.getContent();
            if (isEncrypted) {
                if (PEMReader.this.pFinder == null) {
                    throw new PasswordException("No password finder specified, but a password is required");
                }
                char[] password = PEMReader.this.pFinder.getPassword();
                if (password == null) {
                    throw new PasswordException("Password is null, but a password is required");
                }
                StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
                String dekAlgName = tknz.nextToken();
                byte[] iv = Hex.decode(tknz.nextToken());
                keyBytes = PEMReader.crypt(false, this.b, keyBytes, password, dekAlgName, iv);
            }
            try {
                return ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(keyBytes));
            }
            catch (IOException e2) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e2);
                }
                throw new PEMException(e2.getMessage(), e2);
            }
            catch (IllegalArgumentException e3) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e3);
                }
                throw new PEMException(e3.getMessage(), e3);
            }
        }
    }
}

