/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.cms.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.cms.Attributes;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable attrs) {
        this.attributes = this.copyTable(attrs);
    }

    public AttributeTable(ASN1EncodableVector v2) {
        for (int i2 = 0; i2 != v2.size(); ++i2) {
            Attribute a2 = Attribute.getInstance(v2.get(i2));
            this.addAttribute(a2.getAttrType(), a2);
        }
    }

    public AttributeTable(ASN1Set s2) {
        for (int i2 = 0; i2 != s2.size(); ++i2) {
            Attribute a2 = Attribute.getInstance(s2.getObjectAt(i2));
            this.addAttribute(a2.getAttrType(), a2);
        }
    }

    public AttributeTable(Attribute attr) {
        this.addAttribute(attr.getAttrType(), attr);
    }

    public AttributeTable(Attributes attrs) {
        this(ASN1Set.getInstance(attrs.toASN1Primitive()));
    }

    private void addAttribute(ASN1ObjectIdentifier oid, Attribute a2) {
        Vector<Attribute> v2;
        Object value = this.attributes.get(oid);
        if (value == null) {
            this.attributes.put(oid, a2);
            return;
        }
        if (value instanceof Attribute) {
            v2 = new Vector<Attribute>();
            v2.addElement((Attribute)value);
            v2.addElement(a2);
        } else {
            v2 = (Vector<Attribute>)value;
            v2.addElement(a2);
        }
        this.attributes.put(oid, v2);
    }

    public Attribute get(DERObjectIdentifier oid) {
        return this.get(new ASN1ObjectIdentifier(oid.getId()));
    }

    public Attribute get(ASN1ObjectIdentifier oid) {
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            return (Attribute)((Vector)value).elementAt(0);
        }
        return (Attribute)value;
    }

    public ASN1EncodableVector getAll(DERObjectIdentifier oid) {
        return this.getAll(new ASN1ObjectIdentifier(oid.getId()));
    }

    public ASN1EncodableVector getAll(ASN1ObjectIdentifier oid) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            Enumeration e2 = ((Vector)value).elements();
            while (e2.hasMoreElements()) {
                v2.add((Attribute)e2.nextElement());
            }
        } else if (value != null) {
            v2.add((Attribute)value);
        }
        return v2;
    }

    public int size() {
        int size = 0;
        Enumeration en2 = this.attributes.elements();
        while (en2.hasMoreElements()) {
            Object o2 = en2.nextElement();
            if (o2 instanceof Vector) {
                size += ((Vector)o2).size();
                continue;
            }
            ++size;
        }
        return size;
    }

    public Hashtable toHashtable() {
        return this.copyTable(this.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        Enumeration e2 = this.attributes.elements();
        while (e2.hasMoreElements()) {
            Object value = e2.nextElement();
            if (value instanceof Vector) {
                Enumeration en2 = ((Vector)value).elements();
                while (en2.hasMoreElements()) {
                    v2.add(Attribute.getInstance(en2.nextElement()));
                }
                continue;
            }
            v2.add(Attribute.getInstance(value));
        }
        return v2;
    }

    public Attributes toASN1Structure() {
        return new Attributes(this.toASN1EncodableVector());
    }

    private Hashtable copyTable(Hashtable in) {
        Hashtable out = new Hashtable();
        Enumeration e2 = in.keys();
        while (e2.hasMoreElements()) {
            Object key = e2.nextElement();
            out.put(key, in.get(key));
        }
        return out;
    }

    public AttributeTable add(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        AttributeTable newTable = new AttributeTable(this.attributes);
        newTable.addAttribute(attrType, new Attribute(attrType, (ASN1Set)new DERSet(attrValue)));
        return newTable;
    }

    public AttributeTable remove(ASN1ObjectIdentifier attrType) {
        AttributeTable newTable = new AttributeTable(this.attributes);
        newTable.attributes.remove(attrType);
        return newTable;
    }
}

